/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile.key;

import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.inventories.profile.PlayerNamesMapper;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class GlobalProfileKey {
    protected final UUID playerUUID;
    protected final String playerName;

    public static GlobalProfileKey of(UUID playerUUID) {
        return (GlobalProfileKey)PlayerNamesMapper.getInstance().getKey(playerUUID).getOrElse(() -> new GlobalProfileKey(playerUUID, playerUUID.toString()));
    }

    public static GlobalProfileKey of(OfflinePlayer offlinePlayer) {
        return GlobalProfileKey.of(offlinePlayer.getUniqueId(), offlinePlayer.getName());
    }

    public static GlobalProfileKey of(UUID playerUUID, String playerName) {
        return new GlobalProfileKey(playerUUID, playerName);
    }

    protected GlobalProfileKey(UUID playerUUID, String playerName) {
        this.playerUUID = playerUUID;
        this.playerName = playerName;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    @NotNull
    public OfflinePlayer getOfflinePlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.playerUUID);
    }

    @Nullable
    public Player getOnlinePlayer() {
        return Bukkit.getPlayer((UUID)this.playerUUID);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalProfileKey that = (GlobalProfileKey)o;
        return Objects.equals(this.playerUUID, that.playerUUID);
    }

    public int hashCode() {
        return this.playerUUID.hashCode();
    }

    public String toString() {
        return "GlobalProfileKey{playerUUID=" + String.valueOf(this.playerUUID) + ", playerName='" + this.playerName + "'}";
    }
}

