/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile.group;

import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.inventories.profile.group.GroupingConflict;
import org.mvplugins.multiverse.inventories.util.MVInvi18n;

@ApiStatus.AvailableSince(value="5.2")
public final class GroupingConflictResult {
    private final List<GroupingConflict> conflicts;

    GroupingConflictResult(List<GroupingConflict> conflicts) {
        this.conflicts = conflicts;
    }

    @ApiStatus.AvailableSince(value="5.2")
    public boolean hasConflict() {
        return !this.conflicts.isEmpty();
    }

    @ApiStatus.AvailableSince(value="5.2")
    public void sendConflictIssue(MVCommandIssuer issuer) {
        if (this.conflicts.isEmpty()) {
            return;
        }
        this.conflicts.forEach(conflict -> issuer.sendInfo((MessageKeyProvider)MVInvi18n.CONFLICT_RESULTS, new MessageReplacement[]{MessageReplacement.replace((String)"{group1}").with((Object)conflict.getFirstGroup().getName()), MessageReplacement.replace((String)"{group2}").with((Object)conflict.getSecondGroup().getName()), MessageReplacement.replace((String)"{shares}").with((Object)conflict.getConflictingShares().toString()), MessageReplacement.replace((String)"{worlds}").with((Object)conflict.getWorldsString())}));
        issuer.sendInfo((MessageKeyProvider)MVInvi18n.CONFLICT_FOUND);
    }

    @ApiStatus.AvailableSince(value="5.2")
    public List<GroupingConflict> getConflicts() {
        return this.conflicts;
    }
}

