/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile.data;

import java.util.Map;
import org.mvplugins.multiverse.inventories.profile.data.ProfileData;
import org.mvplugins.multiverse.inventories.share.Sharable;
import org.mvplugins.multiverse.inventories.share.Shares;

public final class SingleSharableData<T>
implements ProfileData {
    private final Sharable<T> sharable;
    private T value;

    public SingleSharableData(Sharable<T> sharable, T value) {
        this.sharable = sharable;
        this.value = value;
    }

    public <S> S get(Sharable<S> sharable) {
        return sharable.equals(this.sharable) ? (S)this.value : null;
    }

    public <S> void set(Sharable<S> sharable, S value) {
        if (sharable.equals(this.sharable)) {
            this.value = value;
        }
    }

    @Override
    public Map<Sharable, Object> getData() {
        return Map.of(this.sharable, this.value);
    }

    @Override
    public void update(ProfileData snapshot) {
        if (snapshot.get(this.sharable) != null) {
            this.value = snapshot.get(this.sharable);
        }
    }

    @Override
    public void update(ProfileData snapshot, Shares shares) {
        if (shares.contains(this.sharable)) {
            this.value = snapshot.get(this.sharable);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.value == null;
    }
}

