/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile.data;

import java.util.UUID;
import org.mvplugins.multiverse.inventories.profile.data.ProfileDataSnapshot;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.profile.key.ProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileType;

public final class PlayerProfile
extends ProfileDataSnapshot {
    private final ContainerType containerType;
    private final String containerName;
    private final ProfileType profileType;
    private final UUID playerUUID;
    private final String playerName;

    public static PlayerProfile newProfile(ProfileKey profileKey) {
        return new PlayerProfile(profileKey.getContainerType(), profileKey.getDataName(), profileKey.getProfileType(), profileKey.getPlayerUUID(), profileKey.getPlayerName());
    }

    private PlayerProfile(ContainerType containerType, String containerName, ProfileType profileType, UUID playerUUID, String playerName) {
        this.containerType = containerType;
        this.profileType = profileType;
        this.containerName = containerName;
        this.playerUUID = playerUUID;
        this.playerName = playerName;
    }

    public ContainerType getContainerType() {
        return this.containerType;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public ProfileType getProfileType() {
        return this.profileType;
    }

    @Override
    public PlayerProfile clone() {
        return (PlayerProfile)super.clone();
    }

    public String toString() {
        return "PlayerProfile{playerUUID=" + String.valueOf(this.playerUUID) + ", playerName='" + this.playerName + "', containerType=" + String.valueOf((Object)this.containerType) + ", containerName='" + this.containerName + "', profileType=" + String.valueOf(this.profileType) + "}";
    }
}

