/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile.bulkedit;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.handleshare.ReadOnlyShareHandler;
import org.mvplugins.multiverse.inventories.profile.bulkedit.PlayerFileAction;
import org.mvplugins.multiverse.inventories.profile.bulkedit.PlayerProfilesPayload;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.profile.key.ProfileFileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileType;
import org.mvplugins.multiverse.inventories.profile.key.ProfileTypes;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.share.Shares;

final class PlayerProfileClearAction
extends PlayerFileAction {
    private final WorldGroupManager worldGroupManager;
    private final Set<ProfileType> profileTypesSet;

    public PlayerProfileClearAction(MultiverseInventories inventories, PlayerProfilesPayload bulkProfilesPayload) {
        super(inventories, bulkProfilesPayload);
        this.worldGroupManager = (WorldGroupManager)inventories.getServiceLocator().getService(WorldGroupManager.class, new Annotation[0]);
        this.profileTypesSet = Set.of(bulkProfilesPayload.profileTypes());
    }

    @Override
    protected CompletableFuture<Void> performAction(ProfileFileKey key) {
        return this.profileDataSource.deletePlayerProfiles(key, this.bulkProfilesPayload.profileTypes()).thenCompose(ignore -> this.profileDataSource.modifyGlobalProfile(key, profile -> profile.setLoadOnLogin(true)));
    }

    @Override
    protected boolean isOnlinePlayerAffected(ProfileFileKey key, Player player) {
        if (!this.profileTypesSet.contains(ProfileTypes.forPlayer(player))) {
            return false;
        }
        List<WorldGroup> groups = this.worldGroupManager.getGroupsForWorld(player.getWorld().getName());
        Shares unhandledSharables = Sharables.enabledOf();
        for (WorldGroup worldGroup : groups) {
            unhandledSharables.removeAll(worldGroup.getApplicableShares());
        }
        if (!unhandledSharables.isEmpty()) {
            return key.getContainerType() == ContainerType.WORLD && player.getWorld().getName().equals(key.getDataName());
        }
        return key.getContainerType() == ContainerType.GROUP && groups.stream().anyMatch(group -> group.getName().equals(key.getDataName()));
    }

    @Override
    protected void updateOnlinePlayerNow(Player player) {
        new ReadOnlyShareHandler(this.inventories, player).handleSharing();
    }
}

