/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jakarta.inject.Provider;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.vavr.CheckedFunction0;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.external.vavr.control.Try;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.profile.AsyncFileIO;
import org.mvplugins.multiverse.inventories.profile.ProfileCacheManager;
import org.mvplugins.multiverse.inventories.profile.ProfileDataSource;
import org.mvplugins.multiverse.inventories.profile.key.GlobalProfileKey;
import org.mvplugins.multiverse.inventories.utils.InvLogging;
import org.mvplugins.multiverse.inventories.utils.minidev.json.JSONObject;
import org.mvplugins.multiverse.inventories.utils.minidev.json.JSONValue;
import org.mvplugins.multiverse.inventories.utils.minidev.json.parser.JSONParser;

@Service
public final class PlayerNamesMapper {
    private static PlayerNamesMapper instance;
    private static final String FILENAME = "playernames.json";
    private final AsyncFileIO asyncFileIO;
    private final Provider<ProfileDataSource> profileDataSourceProvider;
    private final Provider<ProfileCacheManager> profileCacheManagerProvider;
    private final File playerNamesFile;
    private final Map<String, GlobalProfileKey> playerNamesMap;
    private final Map<UUID, GlobalProfileKey> playerUUIDMap;
    private Map<String, Object> playerNamesJson;

    public static PlayerNamesMapper getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Player names mapper has not been initialized yet.");
        }
        return instance;
    }

    @Inject
    private PlayerNamesMapper(@NotNull MultiverseInventories inventories, @NotNull AsyncFileIO asyncFileIO, @NotNull Provider<ProfileDataSource> profileDataSourceProvider, @NotNull Provider<ProfileCacheManager> profileCacheManagerProvider) {
        this.asyncFileIO = asyncFileIO;
        this.profileDataSourceProvider = profileDataSourceProvider;
        this.profileCacheManagerProvider = profileCacheManagerProvider;
        this.playerNamesFile = new File(inventories.getDataFolder(), FILENAME);
        this.playerNamesMap = new ConcurrentHashMap<String, GlobalProfileKey>();
        this.playerUUIDMap = new ConcurrentHashMap<UUID, GlobalProfileKey>();
        instance = this;
    }

    public void loadMap() {
        InvLogging.config("Loading player names map...", new Object[0]);
        this.playerNamesMap.clear();
        this.playerUUIDMap.clear();
        if (this.playerNamesFile.exists()) {
            this.loadFromPlayerNamesFile();
        } else {
            this.buildPlayerNamesMap();
        }
    }

    private void loadFromPlayerNamesFile() {
        try (FileReader fileReader = new FileReader(this.playerNamesFile);){
            this.playerNamesJson = new ConcurrentHashMap<String, Object>((JSONObject)new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(fileReader));
            if (this.playerNamesJson.isEmpty()) {
                this.buildPlayerNamesMap();
                return;
            }
            this.playerNamesJson.forEach((uuidStr, name) -> Try.of((CheckedFunction0 & Serializable)() -> UUID.fromString(uuidStr)).onSuccess(uuid -> {
                String playerName = String.valueOf(name);
                GlobalProfileKey globalProfileKey = GlobalProfileKey.of(uuid, playerName);
                this.playerNamesMap.put(playerName, globalProfileKey);
                this.playerUUIDMap.put((UUID)uuid, globalProfileKey);
            }).onFailure(throwable -> {
                InvLogging.warning("Not a valid UUID: %s", uuidStr);
                InvLogging.warning(throwable.getMessage(), new Object[0]);
            }));
        }
        catch (Exception e) {
            InvLogging.warning("Could not load player names map. Rebuilding instead...", new Object[0]);
            e.printStackTrace();
            this.buildPlayerNamesMap();
        }
    }

    private void buildPlayerNamesMap() {
        InvLogging.info("Generating player names map... This may take a while.", new Object[0]);
        this.playerNamesJson = new ConcurrentHashMap<String, Object>();
        ProfileDataSource profileDataSource = (ProfileDataSource)this.profileDataSourceProvider.get();
        CompletableFuture[] futures = (CompletableFuture[])profileDataSource.listGlobalProfileUUIDs().stream().map(uuid -> profileDataSource.getGlobalProfile(GlobalProfileKey.of(uuid, "")).thenAccept(globalProfile -> this.setPlayerName((UUID)uuid, globalProfile.getLastKnownName()))).toArray(CompletableFuture[]::new);
        ((CompletableFuture)CompletableFuture.allOf(futures).thenCompose(ignore -> this.savePlayerNames())).join();
        ((ProfileCacheManager)this.profileCacheManagerProvider.get()).clearAllGlobalProfileCaches();
        InvLogging.info("Generated player names map.", new Object[0]);
    }

    boolean setPlayerName(UUID uuid, String name) {
        if (this.playerNamesJson == null) {
            throw new IllegalStateException("Player names mapper has not been loaded yet.");
        }
        if (Strings.isNullOrEmpty((String)name)) {
            return false;
        }
        if (this.getKey(name).filter(g -> g.getPlayerUUID().equals(uuid)).isDefined()) {
            return false;
        }
        InvLogging.finer("Setting player name mapping for %s to %s", uuid, name);
        GlobalProfileKey globalProfileKey = GlobalProfileKey.of(uuid, name);
        Object oldName = this.playerNamesJson.put(uuid.toString(), name);
        this.playerNamesMap.remove(String.valueOf(oldName));
        this.playerNamesMap.put(name, globalProfileKey);
        this.playerUUIDMap.put(uuid, globalProfileKey);
        return true;
    }

    CompletableFuture<Void> savePlayerNames() {
        if (this.playerNamesJson == null) {
            throw new IllegalStateException("Player names mapper has not been loaded yet.");
        }
        return this.asyncFileIO.queueFileAction(this.playerNamesFile, () -> {
            InvLogging.finer("Saving player names map...", new Object[0]);
            try (FileWriter fileWriter = new FileWriter(this.playerNamesFile);){
                fileWriter.write(JSONValue.toJSONString(this.playerNamesJson));
                InvLogging.finer("Saving player names map... Done!", new Object[0]);
            }
            catch (Exception e) {
                InvLogging.severe("Could not save player names map.", new Object[0]);
                e.printStackTrace();
            }
        });
    }

    public Option<GlobalProfileKey> getKey(String playerName) {
        return Option.of((Object)this.playerNamesMap.get(playerName));
    }

    public Option<GlobalProfileKey> getKey(UUID playerUUID) {
        return Option.of((Object)this.playerUUIDMap.get(playerUUID));
    }

    public List<GlobalProfileKey> getKeys() {
        return this.playerNamesMap.values().stream().toList();
    }
}

