/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.handleshare;

import java.util.List;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.event.ShareHandlingEvent;
import org.mvplugins.multiverse.inventories.event.WorldChangeShareHandlingEvent;
import org.mvplugins.multiverse.inventories.handleshare.ShareHandler;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainer;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.share.Shares;
import org.mvplugins.multiverse.inventories.util.Perm;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

public final class WorldChangeShareHandler
extends ShareHandler {
    private final String fromWorld;
    private final String toWorld;
    private final List<WorldGroup> fromWorldGroups;
    private final List<WorldGroup> toWorldGroups;

    public WorldChangeShareHandler(MultiverseInventories inventories, Player player, String fromWorld, String toWorld) {
        super(inventories, player);
        this.fromWorld = fromWorld;
        this.toWorld = toWorld;
        this.fromWorldGroups = this.worldGroupManager.getGroupsForWorld(fromWorld);
        this.toWorldGroups = this.worldGroupManager.getGroupsForWorld(toWorld);
    }

    @Override
    protected ShareHandlingEvent createEvent() {
        return new WorldChangeShareHandlingEvent(this.player, this.affectedProfiles, this.fromWorld, this.toWorld);
    }

    @Override
    protected void prepareProfiles() {
        InvLogging.fine("=== %s traveling from world: %s to world: %s ===", this.player.getName(), this.fromWorld, this.toWorld);
        if (this.isPlayerAffectedByChange()) {
            this.addWriteProfiles();
            this.addReadProfiles();
        } else if (this.inventoriesConfig.getAlwaysWriteWorldProfile()) {
            this.affectedProfiles.addWriteProfile(this.worldProfileContainerStore.getContainer(this.fromWorld).getProfileKey(this.player), this.fromWorldGroups.isEmpty() && !this.inventoriesConfig.getUseOptionalsForUngroupedWorlds() ? Sharables.standard() : Sharables.enabled());
        }
    }

    private boolean isPlayerAffectedByChange() {
        if (this.isPlayerBypassingChange()) {
            this.logBypass();
            return false;
        }
        return true;
    }

    private boolean isPlayerBypassingChange() {
        return Perm.BYPASS_WORLD.hasBypass(this.player, this.fromWorld);
    }

    private void addWriteProfiles() {
        new WriteProfileAggregator().conditionallyAddWriteProfiles();
    }

    private void addReadProfiles() {
        new ReadProfilesAggregator().addReadProfiles();
    }

    private class WriteProfileAggregator {
        private final Shares handledShares = Sharables.noneOf();

        private WriteProfileAggregator() {
        }

        private void conditionallyAddWriteProfiles() {
            Shares sharesToWrite;
            WorldChangeShareHandler.this.fromWorldGroups.forEach(this::conditionallyAddWriteProfileForGroup);
            Shares shares = sharesToWrite = WorldChangeShareHandler.this.inventoriesConfig.getAlwaysWriteWorldProfile() ? Sharables.enabled() : Sharables.enabledOf().setSharing(this.handledShares, false);
            if (!sharesToWrite.isEmpty()) {
                WorldChangeShareHandler.this.affectedProfiles.addWriteProfile(WorldChangeShareHandler.this.worldProfileContainerStore.getContainer(WorldChangeShareHandler.this.fromWorld).getProfileKey(WorldChangeShareHandler.this.player), sharesToWrite);
            }
        }

        private void conditionallyAddWriteProfileForGroup(WorldGroup worldGroup) {
            if (!worldGroup.containsWorld(WorldChangeShareHandler.this.toWorld)) {
                this.addWriteProfileForGroup(worldGroup);
            }
            this.handledShares.addAll(worldGroup.getApplicableShares());
            this.handledShares.addAll(worldGroup.getDisabledShares());
        }

        void addWriteProfileForGroup(WorldGroup worldGroup) {
            ProfileContainer container = worldGroup.getGroupProfileContainer();
            WorldChangeShareHandler.this.affectedProfiles.addWriteProfile(container.getProfileKey(WorldChangeShareHandler.this.player), worldGroup.getApplicableShares());
        }
    }

    private class ReadProfilesAggregator {
        private final Shares handledShares = Sharables.noneOf();

        private ReadProfilesAggregator() {
        }

        private void addReadProfiles() {
            this.addReadProfilesFromToWorldGroups();
            this.useToWorldForMissingShares();
        }

        private void addReadProfilesFromToWorldGroups() {
            if (WorldChangeShareHandler.this.toWorldGroups.isEmpty()) {
                InvLogging.finer("No groups for toWorld.", new Object[0]);
                return;
            }
            WorldChangeShareHandler.this.toWorldGroups.forEach(this::conditionallyAddReadProfileForWorldGroup);
        }

        private void conditionallyAddReadProfileForWorldGroup(WorldGroup worldGroup) {
            if (!this.isPlayerAffectedByChange(worldGroup)) {
                return;
            }
            if (this.isFromWorldNotInToWorldGroup(worldGroup)) {
                this.addReadProfileForWorldGroup(worldGroup);
            }
            this.handledShares.addAll(worldGroup.getApplicableShares());
            this.handledShares.addAll(worldGroup.getDisabledShares());
        }

        private boolean isPlayerAffectedByChange(WorldGroup worldGroup) {
            if (this.isPlayerBypassingChange(worldGroup)) {
                WorldChangeShareHandler.this.logBypass();
                return false;
            }
            return true;
        }

        private boolean isPlayerBypassingChange(WorldGroup worldGroup) {
            return Perm.BYPASS_GROUP.hasBypass(WorldChangeShareHandler.this.player, worldGroup.getName());
        }

        private boolean isFromWorldNotInToWorldGroup(WorldGroup worldGroup) {
            if (WorldChangeShareHandler.this.inventoriesConfig.getDefaultUngroupedWorlds() && !WorldChangeShareHandler.this.worldGroupManager.hasConfiguredGroup(WorldChangeShareHandler.this.fromWorld) && worldGroup.equals(WorldChangeShareHandler.this.worldGroupManager.getDefaultGroup())) {
                return false;
            }
            return !worldGroup.containsWorld(WorldChangeShareHandler.this.fromWorld);
        }

        private void addReadProfileForWorldGroup(WorldGroup worldGroup) {
            Shares applicableShares = Sharables.fromShares(worldGroup.getApplicableShares());
            if (!WorldChangeShareHandler.this.inventoriesConfig.getApplyLastLocationForAllTeleports()) {
                InvLogging.finer("Removing lastLocation from applicableShares as it is not applied for all teleports", new Object[0]);
                applicableShares.remove(Sharables.LAST_LOCATION);
            }
            WorldChangeShareHandler.this.affectedProfiles.addReadProfile(worldGroup.getGroupProfileContainer().getProfileKey(WorldChangeShareHandler.this.player), applicableShares);
        }

        private void useToWorldForMissingShares() {
            Shares unhandledShares = WorldChangeShareHandler.this.toWorldGroups.isEmpty() && !WorldChangeShareHandler.this.inventoriesConfig.getUseOptionalsForUngroupedWorlds() ? Sharables.standardOf() : Sharables.enabledOf();
            unhandledShares.removeAll(this.handledShares);
            if (!WorldChangeShareHandler.this.inventoriesConfig.getApplyLastLocationForAllTeleports()) {
                InvLogging.finer("Removing lastLocation from unhandledShares as it is not applied for all teleports", new Object[0]);
                unhandledShares.remove(Sharables.LAST_LOCATION);
            }
            if (unhandledShares.isEmpty()) {
                return;
            }
            InvLogging.finer("%s are left unhandled, defaulting to toWorld", unhandledShares);
            WorldChangeShareHandler.this.affectedProfiles.addReadProfile(WorldChangeShareHandler.this.worldProfileContainerStore.getContainer(WorldChangeShareHandler.this.toWorld).getProfileKey(WorldChangeShareHandler.this.player), unhandledShares);
        }
    }
}

