/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.dataimport.worldinventories;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import me.drayshak.WorldInventories.Group;
import me.drayshak.WorldInventories.WIPlayerInventory;
import me.drayshak.WorldInventories.WIPlayerStats;
import me.drayshak.WorldInventories.WorldInventories;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.config.InventoriesConfig;
import org.mvplugins.multiverse.inventories.dataimport.DataImportException;
import org.mvplugins.multiverse.inventories.profile.ProfileDataSource;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainer;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainerStoreProvider;
import org.mvplugins.multiverse.inventories.profile.data.PlayerProfile;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.profile.key.ProfileTypes;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

final class WorldInventoriesImportHelper {
    @NotNull
    private final WorldInventories worldInventories;
    private final WorldGroupManager worldGroupManager;
    private final InventoriesConfig inventoriesConfig;
    private final ProfileContainerStoreProvider profileContainerStoreProvider;
    private final ProfileDataSource profileDataSource;

    WorldInventoriesImportHelper(@NotNull WorldInventories worldInventories, @NotNull WorldGroupManager worldGroupManager, @NotNull InventoriesConfig inventoriesConfig, @NotNull ProfileContainerStoreProvider profileContainerStoreProvider, @NotNull ProfileDataSource profileDataSource) {
        this.worldInventories = worldInventories;
        this.worldGroupManager = worldGroupManager;
        this.inventoriesConfig = inventoriesConfig;
        this.profileContainerStoreProvider = profileContainerStoreProvider;
        this.profileDataSource = profileDataSource;
    }

    void importData() throws DataImportException {
        WorldGroup defaultWorldGroup;
        List wiGroups;
        try {
            wiGroups = this.worldInventories.getGroups();
        }
        catch (Exception e) {
            throw new DataImportException("Unable to import from this version of WorldInventories!").setCauseException(e);
        }
        catch (Error e) {
            throw new DataImportException("Unable to import from this version of WorldInventories!");
        }
        if (wiGroups == null) {
            throw new DataImportException("No data to import from WorldInventories!");
        }
        if (!wiGroups.isEmpty() && (defaultWorldGroup = this.worldGroupManager.getDefaultGroup()) != null) {
            this.worldGroupManager.removeGroup(defaultWorldGroup);
            InvLogging.info("Removed automatically created world group in favor of imported groups.", new Object[0]);
        }
        this.createGroups(wiGroups);
        Set<ProfileContainer> noGroupWorlds = this.getWorldsWithoutGroups();
        this.inventoriesConfig.save();
        OfflinePlayer[] offlinePlayers = Bukkit.getServer().getOfflinePlayers();
        InvLogging.info("Processing data for " + offlinePlayers.length + " players.  The larger than number, the longer this process will take.  Please be patient. :)  Your server will freeze for the duration.", new Object[0]);
        int playerCount = 0;
        for (OfflinePlayer player : offlinePlayers) {
            InvLogging.finer("(" + ++playerCount + "/" + offlinePlayers.length + ")Processing WorldInventories data for player: " + player.getName(), new Object[0]);
            for (Group wiGroup : wiGroups) {
                WorldGroup worldGroup = this.worldGroupManager.getGroup(wiGroup.getName());
                if (worldGroup == null) {
                    InvLogging.finest("Could not import player data for WorldInventories group: " + wiGroup.getName() + " because there is no Multiverse-Inventories group by that name.", new Object[0]);
                    continue;
                }
                this.transferData(player, wiGroup, worldGroup.getGroupProfileContainer());
            }
            for (ProfileContainer container : noGroupWorlds) {
                this.transferData(player, null, container);
            }
        }
    }

    private void createGroups(List<Group> wiGroups) {
        for (Group wiGroup : wiGroups) {
            if (wiGroup.getWorlds().isEmpty()) {
                InvLogging.warning("Group '" + wiGroup.getName() + "' has no worlds.  You may need to add these manually!", new Object[0]);
            }
            WorldGroup newGroup = this.worldGroupManager.newEmptyGroup(wiGroup.getName());
            for (String worldName : wiGroup.getWorlds()) {
                newGroup.addWorld(worldName);
            }
            try {
                if (WorldInventories.doStats) {
                    newGroup.getShares().mergeShares(Sharables.allOf());
                } else {
                    newGroup.getShares().setSharing(Sharables.ALL_INVENTORY, true);
                }
            }
            catch (Exception ignore) {
                InvLogging.warning("Group '" + wiGroup.getName() + "' unable to import fully, sharing only inventory.", new Object[0]);
                newGroup.getShares().setSharing(Sharables.ALL_INVENTORY, true);
            }
            catch (Error e) {
                InvLogging.warning("Group '" + wiGroup.getName() + "' unable to import fully, sharing only inventory.", new Object[0]);
                newGroup.getShares().setSharing(Sharables.ALL_INVENTORY, true);
            }
            this.worldGroupManager.updateGroup(newGroup);
            InvLogging.info("Created Multiverse-Inventories group: " + wiGroup.getName(), new Object[0]);
        }
    }

    private Set<ProfileContainer> getWorldsWithoutGroups() {
        LinkedHashSet<ProfileContainer> noGroupWorlds = new LinkedHashSet<ProfileContainer>();
        for (World world : Bukkit.getWorlds()) {
            if (!this.worldGroupManager.getGroupsForWorld(world.getName()).isEmpty()) continue;
            InvLogging.fine("Added ungrouped world for importing.", new Object[0]);
            ProfileContainer container = this.profileContainerStoreProvider.getStore(ContainerType.WORLD).getContainer(world.getName());
            noGroupWorlds.add(container);
        }
        return noGroupWorlds;
    }

    private void transferData(OfflinePlayer player, Group wiGroup, ProfileContainer profileContainer) {
        PlayerProfile playerProfile = profileContainer.getPlayerProfileNow(ProfileTypes.SURVIVAL, player);
        WIPlayerInventory wiInventory = this.loadPlayerInventory(player, wiGroup);
        WIPlayerStats wiStats = this.loadPlayerStats(player, wiGroup);
        if (wiInventory != null) {
            playerProfile.set(Sharables.INVENTORY, wiInventory.getItems());
            playerProfile.set(Sharables.ARMOR, wiInventory.getArmour());
        }
        if (wiStats != null) {
            playerProfile.set(Sharables.HEALTH, Double.valueOf(wiStats.getHealth()));
            playerProfile.set(Sharables.SATURATION, Float.valueOf(wiStats.getSaturation()));
            playerProfile.set(Sharables.EXPERIENCE, Float.valueOf(wiStats.getExp()));
            playerProfile.set(Sharables.LEVEL, wiStats.getLevel());
            playerProfile.set(Sharables.EXHAUSTION, Float.valueOf(wiStats.getExhaustion()));
            playerProfile.set(Sharables.FOOD_LEVEL, wiStats.getFoodLevel());
        }
        this.profileDataSource.updatePlayerProfile(playerProfile);
        InvLogging.finest("Player's data imported successfully for group: " + profileContainer.getContainerName(), new Object[0]);
    }

    private File getFile(OfflinePlayer player, Group group, DataType dataType) {
        StringBuilder path = new StringBuilder();
        path.append(File.separator);
        if (group == null) {
            path.append("default");
        } else {
            path.append(group.getName());
        }
        path.insert(0, this.worldInventories.getDataFolder().getAbsolutePath());
        path.append(File.separator).append(player.getName()).append(dataType.fileExtension);
        File file = new File(path.toString());
        if (!file.exists()) {
            file = null;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WIPlayerInventory loadPlayerInventory(OfflinePlayer player, Group group) {
        File file = this.getFile(player, group, DataType.INVENTORY);
        if (file == null) {
            return null;
        }
        WIPlayerInventory playerInventory = null;
        FileInputStream fIS = null;
        ObjectInputStream obIn = null;
        try {
            fIS = new FileInputStream(file);
            obIn = new ObjectInputStream(fIS);
            playerInventory = (WIPlayerInventory)obIn.readObject();
        }
        catch (Exception exception) {
        }
        finally {
            if (obIn != null) {
                try {
                    obIn.close();
                }
                catch (IOException iOException) {}
            }
            if (fIS != null) {
                try {
                    fIS.close();
                }
                catch (IOException iOException) {}
            }
        }
        return playerInventory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WIPlayerStats loadPlayerStats(OfflinePlayer player, Group group) {
        File file = this.getFile(player, group, DataType.STATS);
        if (file == null) {
            return null;
        }
        WIPlayerStats playerstats = null;
        FileInputStream fIS = null;
        ObjectInputStream obIn = null;
        try {
            fIS = new FileInputStream(file);
            obIn = new ObjectInputStream(fIS);
            playerstats = (WIPlayerStats)obIn.readObject();
        }
        catch (Exception exception) {
        }
        finally {
            if (obIn != null) {
                try {
                    obIn.close();
                }
                catch (IOException iOException) {}
            }
            if (fIS != null) {
                try {
                    fIS.close();
                }
                catch (IOException iOException) {}
            }
        }
        return playerstats;
    }

    private static enum DataType {
        INVENTORY(".inventory"),
        STATS(".stats");

        private String fileExtension;

        private DataType(String fileExtension) {
            this.fileExtension = fileExtension;
        }
    }
}

