/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands.prompts;

import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.commands.prompts.GroupSharesPrompt;
import org.mvplugins.multiverse.inventories.commands.prompts.GroupWorldsPrompt;
import org.mvplugins.multiverse.inventories.commands.prompts.InventoriesPrompt;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.util.MVInvi18n;

final class GroupModifyPrompt
extends InventoriesPrompt {
    protected final WorldGroup group;

    public GroupModifyPrompt(MultiverseInventories plugin, MVCommandIssuer issuer, WorldGroup group) {
        super(plugin, issuer);
        this.group = group;
    }

    @Override
    @NotNull
    public Message getPromptMessage(@NotNull ConversationContext conversationContext) {
        return Message.of((MessageKeyProvider)MVInvi18n.GROUP_MODIFYPROMPT, (MessageReplacement[])new MessageReplacement[]{MessageReplacement.replace((String)"{group}").with((Object)this.group.getName())});
    }

    public Prompt acceptInput(@NotNull ConversationContext conversationContext, String input) {
        if ("worlds".equalsIgnoreCase(input)) {
            return new GroupWorldsPrompt(this.plugin, this.issuer, this.group, this, false);
        }
        if (input.equalsIgnoreCase("shares")) {
            return new GroupSharesPrompt(this.plugin, this.issuer, this.group, this, false);
        }
        this.issuer.sendError((MessageKeyProvider)MVInvi18n.GROUP_INVALIDOPTION);
        return this;
    }
}

