/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.core.utils.StringFormatter;
import org.mvplugins.multiverse.external.jakarta.annotation.PostConstruct;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;

@Service
final class PlaceholderExpansionHook
extends PlaceholderExpansion {
    private final MultiverseInventories plugin;
    private final WorldGroupManager worldGroupManager;

    @Inject
    PlaceholderExpansionHook(@NotNull MultiverseInventories plugin, @NotNull WorldGroupManager worldGroupManager) {
        this.plugin = plugin;
        this.worldGroupManager = worldGroupManager;
    }

    @PostConstruct
    public boolean register() {
        return super.register();
    }

    @NotNull
    public String getIdentifier() {
        return "multiverse-inventories";
    }

    @NotNull
    public String getAuthor() {
        return StringFormatter.joinAnd((List)this.plugin.getDescription().getAuthors());
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    @Nullable
    public String onRequest(OfflinePlayer offlinePlayer, @NotNull String params) {
        ArrayList paramsArray = Lists.newArrayList((Object[])REPatterns.UNDERSCORE.split(params));
        if (paramsArray.isEmpty() || paramsArray.size() < 2) {
            this.warning("Placeholder has too little parameters: " + params);
            return null;
        }
        return switch ((String)paramsArray.get(0)) {
            case "world" -> this.worldPlaceholders(offlinePlayer, paramsArray);
            case "group" -> this.groupPlaceholders(offlinePlayer, paramsArray);
            default -> {
                this.warning("Unknown placeholder: " + (String)paramsArray.get(0));
                yield null;
            }
        };
    }

    private String worldPlaceholders(OfflinePlayer offlinePlayer, List<String> paramsArray) {
        String world = null;
        if (paramsArray.size() > 2) {
            world = paramsArray.get(paramsArray.size() - 1);
        }
        if (offlinePlayer instanceof Player) {
            Player player = (Player)offlinePlayer;
            world = player.getWorld().getName();
        }
        if (world == null) {
            this.warning("Please specify a world name to use with this placeholder.");
            return null;
        }
        return switch (paramsArray.get(1)) {
            case "groups" -> StringFormatter.join(this.worldGroupManager.getGroupsForWorld(world).stream().map(WorldGroup::getName).toList(), (String)", ");
            case "groupcount" -> String.valueOf(this.worldGroupManager.getGroupsForWorld(world).size());
            default -> {
                this.warning("Unknown world placeholder arg: " + paramsArray.get(1));
                yield null;
            }
        };
    }

    private String groupPlaceholders(OfflinePlayer offlinePlayer, List<String> paramsArray) {
        Player player;
        WorldGroup group = null;
        if (paramsArray.size() > 2) {
            group = this.worldGroupManager.getGroup(paramsArray.get(paramsArray.size() - 1));
            if (group == null) {
                this.warning("Group not found: " + paramsArray.get(paramsArray.size() - 1));
                return null;
            }
        } else if (offlinePlayer instanceof Player && (group = (WorldGroup)this.worldGroupManager.getGroupsForWorld((player = (Player)offlinePlayer).getWorld().getName()).stream().findFirst().orElse(null)) == null) {
            return "ungrouped world";
        }
        if (group == null) {
            this.warning("Please specify a group name to use with this placeholder.");
            return null;
        }
        return this.getGroupPlaceholderValue(group, paramsArray.get(1));
    }

    private String getGroupPlaceholderValue(WorldGroup worldGroup, String placeholder) {
        return switch (placeholder) {
            case "name" -> worldGroup.getName();
            case "worlds" -> StringFormatter.join(worldGroup.getApplicableWorlds(), (String)", ");
            case "shares" -> StringFormatter.join(worldGroup.getShares().toStringList(), (String)", ");
            case "players" -> StringFormatter.join(worldGroup.getApplicableWorlds().stream().map(Bukkit::getWorld).filter(Objects::nonNull).flatMap(world -> world.getPlayers().stream().map(Player::getName)).toList(), (String)", ");
            case "playercount" -> worldGroup.getApplicableWorlds().stream().map(Bukkit::getWorld).filter(Objects::nonNull).map(World::getPlayers).map(List::size).reduce(Integer::sum).orElse(0).toString();
            default -> {
                this.warning("Unknown group placeholder arg: " + placeholder);
                yield null;
            }
        };
    }
}

