/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.util;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Base64;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.vavr.CheckedFunction0;
import org.mvplugins.multiverse.external.vavr.control.Try;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.config.InventoriesConfig;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

public final class ItemStackConverter {
    private static final boolean hasByteSerializeSupport = (Boolean)Try.run(() -> ItemStack.class.getMethod("deserializeBytes", byte[].class)).map(ignore -> true).recover(ignore -> false).getOrElse((Object)false);
    private static InventoriesConfig config = null;

    public static void init(MultiverseInventories plugin) {
        config = (InventoriesConfig)plugin.getServiceLocator().getService(InventoriesConfig.class, new Annotation[0]);
    }

    public static boolean isEmptyItemStack(@Nullable ItemStack itemStack) {
        return itemStack == null || itemStack.getType() == Material.AIR || itemStack.getAmount() == 0;
    }

    @Nullable
    public static ItemStack deserialize(Object obj) {
        if (obj instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)obj;
            return itemStack;
        }
        if (hasByteSerializeSupport && obj instanceof String) {
            String string = (String)obj;
            byte[] bytes = Base64.getDecoder().decode(string);
            return ItemStack.deserializeBytes((byte[])bytes);
        }
        return null;
    }

    @Nullable
    public static Object serialize(ItemStack itemStack) {
        if (ItemStackConverter.isEmptyItemStack(itemStack)) {
            return null;
        }
        if (config == null || !config.getUseByteSerializationForInventoryData() || !hasByteSerializeSupport) {
            return itemStack;
        }
        return Try.of((CheckedFunction0 & Serializable)() -> Base64.getEncoder().encodeToString(itemStack.serializeAsBytes())).onFailure(e -> InvLogging.severe("Could not byte serialize item stack: %s", e.getMessage())).getOrNull();
    }

    public static boolean hasByteSerializeSupport() {
        return hasByteSerializeSupport;
    }

    private ItemStackConverter() {
        throw new IllegalStateException();
    }
}

