/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile.group;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.jvnet.hk2.annotations.Contract;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.MVCommandManager;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.config.InventoriesConfig;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainerStoreProvider;
import org.mvplugins.multiverse.inventories.profile.group.GroupingConflict;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.share.Shares;
import org.mvplugins.multiverse.inventories.util.MVInvi18n;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Contract
abstract class AbstractWorldGroupManager
implements WorldGroupManager {
    static final String DEFAULT_GROUP_NAME = "default";
    protected final Map<String, WorldGroup> groupNamesMap = new LinkedHashMap<String, WorldGroup>();
    protected final MultiverseInventories plugin;
    protected final MVCommandManager commandManager;
    protected final InventoriesConfig inventoriesConfig;
    protected final ProfileContainerStoreProvider profileContainerStoreProvider;
    protected final WorldManager worldManager;

    public AbstractWorldGroupManager(@NotNull MultiverseInventories plugin, @NotNull MVCommandManager commandManager, @NotNull InventoriesConfig config, @NotNull ProfileContainerStoreProvider profileContainerStoreProvider, @NotNull WorldManager worldManager) {
        this.plugin = plugin;
        this.commandManager = commandManager;
        this.inventoriesConfig = config;
        this.profileContainerStoreProvider = profileContainerStoreProvider;
        this.worldManager = worldManager;
    }

    @Override
    public WorldGroup getGroup(String groupName) {
        return this.groupNamesMap.get(groupName.toLowerCase());
    }

    @Override
    public List<WorldGroup> getGroups() {
        return List.copyOf(this.getGroupNames().values());
    }

    @Override
    public List<WorldGroup> getGroupsForWorld(String worldName) {
        worldName = worldName.toLowerCase();
        ArrayList<WorldGroup> worldGroups = new ArrayList<WorldGroup>();
        for (WorldGroup worldGroup : this.getGroupNames().values()) {
            if (!worldGroup.containsWorld(worldName)) continue;
            worldGroups.add(worldGroup);
        }
        if (worldGroups.isEmpty() && this.inventoriesConfig.getDefaultUngroupedWorlds() && this.worldManager.isWorld(worldName)) {
            InvLogging.finer("Returning default group for world: " + worldName, new Object[0]);
            worldGroups.add(this.getDefaultGroup());
        }
        return worldGroups;
    }

    @Override
    public boolean hasConfiguredGroup(String worldName) {
        return this.groupNamesMap.values().stream().anyMatch(worldGroup -> worldGroup.getWorlds().contains(worldName));
    }

    protected Map<String, WorldGroup> getGroupNames() {
        return this.groupNamesMap;
    }

    @Override
    public void updateGroup(WorldGroup worldGroup) {
        this.getGroupNames().put(worldGroup.getName().toLowerCase(), worldGroup);
        worldGroup.recalculateApplicableShares();
    }

    @Override
    public boolean removeGroup(WorldGroup worldGroup) {
        return this.getGroupNames().remove(worldGroup.getName().toLowerCase()) != null;
    }

    @Override
    public WorldGroup newEmptyGroup(String name) {
        if (this.getGroup(name) != null) {
            return null;
        }
        return new WorldGroup(this, this.profileContainerStoreProvider, this.inventoriesConfig, name);
    }

    @Override
    public void createDefaultGroup() {
        if (this.getGroup(DEFAULT_GROUP_NAME) != null) {
            return;
        }
        World defaultWorld = (World)this.worldManager.getDefaultWorld().flatMap(LoadedMultiverseWorld::getBukkitWorld).fold(() -> (World)Bukkit.getWorlds().get(0), world -> world);
        World defaultNether = Bukkit.getWorld((String)(defaultWorld.getName() + "_nether"));
        World defaultEnd = Bukkit.getWorld((String)(defaultWorld.getName() + "_the_end"));
        WorldGroup worldGroup = new WorldGroup(this, this.profileContainerStoreProvider, this.inventoriesConfig, DEFAULT_GROUP_NAME);
        worldGroup.getShares().mergeShares(Sharables.allOf());
        worldGroup.addWorld(defaultWorld);
        if (defaultNether != null) {
            worldGroup.addWorld(defaultNether);
        }
        if (defaultEnd != null) {
            worldGroup.addWorld(defaultEnd);
        }
        this.updateGroup(worldGroup);
        worldGroup.recalculateApplicableShares();
        InvLogging.info("Created a default group for you containing all of your default worlds: " + String.join((CharSequence)", ", worldGroup.getWorlds()), new Object[0]);
    }

    @Override
    public WorldGroup getDefaultGroup() {
        WorldGroup group = this.getGroupNames().get(DEFAULT_GROUP_NAME);
        if (group == null) {
            group = this.newEmptyGroup(DEFAULT_GROUP_NAME);
            group.getShares().setSharing(Sharables.allOf(), true);
            this.updateGroup(group);
        }
        return group;
    }

    @Override
    public List<GroupingConflict> checkGroups() {
        ArrayList<GroupingConflict> conflicts = new ArrayList<GroupingConflict>();
        HashMap<WorldGroup, WorldGroup> previousConflicts = new HashMap<WorldGroup, WorldGroup>();
        for (WorldGroup checkingGroup : this.getGroupNames().values()) {
            for (String worldName : checkingGroup.getWorlds()) {
                for (WorldGroup worldGroup : this.getGroupsForWorld(worldName)) {
                    if (checkingGroup.equals(worldGroup) || previousConflicts.containsKey(checkingGroup) && ((WorldGroup)previousConflicts.get(checkingGroup)).equals(worldGroup) || previousConflicts.containsKey(worldGroup) && ((WorldGroup)previousConflicts.get(worldGroup)).equals(checkingGroup)) continue;
                    previousConflicts.put(checkingGroup, worldGroup);
                    Shares conflictingShares = worldGroup.getShares().compare(checkingGroup.getShares());
                    if (conflictingShares.isEmpty() || checkingGroup.getWorlds().containsAll(worldGroup.getWorlds()) || worldGroup.getWorlds().containsAll(checkingGroup.getWorlds())) continue;
                    conflicts.add(new GroupingConflict(checkingGroup, worldGroup, Sharables.fromShares(conflictingShares)));
                }
            }
        }
        return conflicts;
    }

    @Override
    public void checkForConflicts(MVCommandIssuer issuer) {
        if (issuer == null) {
            issuer = this.commandManager.getCommandIssuer((Object)Bukkit.getConsoleSender());
        }
        issuer.sendInfo((MessageKeyProvider)MVInvi18n.CONFLICT_CHECKING);
        List<GroupingConflict> conflicts = this.checkGroups();
        for (GroupingConflict conflict : conflicts) {
            issuer.sendInfo((MessageKeyProvider)MVInvi18n.CONFLICT_RESULTS, new MessageReplacement[]{MessageReplacement.replace((String)"{group1}").with((Object)conflict.getFirstGroup().getName()), MessageReplacement.replace((String)"{group2}").with((Object)conflict.getSecondGroup().getName()), MessageReplacement.replace((String)"{shares}").with((Object)conflict.getConflictingShares().toString()), MessageReplacement.replace((String)"{worlds}").with((Object)conflict.getWorldsString())});
        }
        if (!conflicts.isEmpty()) {
            issuer.sendInfo((MessageKeyProvider)MVInvi18n.CONFLICT_FOUND);
        } else {
            issuer.sendInfo((MessageKeyProvider)MVInvi18n.CONFLICT_NOTFOUND);
        }
    }

    @Override
    public void recalculateApplicableShares() {
        this.getGroupNames().values().forEach(WorldGroup::recalculateApplicableShares);
    }
}

