/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.profile.key.ProfileFileKey;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

@Service
final class ProfileFilesLocator {
    private static final String JSON = ".json";
    private final File worldFolder;
    private final File groupFolder;
    private final File globalFolder;

    @Inject
    ProfileFilesLocator(@NotNull MultiverseInventories plugin) throws IOException {
        plugin.getDataFolder().mkdirs();
        this.worldFolder = new File(plugin.getDataFolder(), "worlds");
        if (!this.worldFolder.exists() && !this.worldFolder.mkdirs()) {
            throw new IOException("Could not create world folder!");
        }
        this.groupFolder = new File(plugin.getDataFolder(), "groups");
        if (!this.groupFolder.exists() && !this.groupFolder.mkdirs()) {
            throw new IOException("Could not create group folder!");
        }
        this.globalFolder = new File(plugin.getDataFolder(), "players");
        if (!this.globalFolder.exists() && !this.globalFolder.mkdirs()) {
            throw new IOException("Could not create player folder!");
        }
    }

    File getWorldFolder() {
        return this.worldFolder;
    }

    File getGroupFolder() {
        return this.groupFolder;
    }

    File getContainerFolder(ContainerType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ContainerType.GROUP -> this.groupFolder;
            case ContainerType.WORLD -> this.worldFolder;
        };
    }

    List<File> listProfileContainerFolders(ContainerType type) {
        return (List)Option.of((Object)this.getContainerFolder(type).listFiles()).map(filesList -> Arrays.stream(filesList).filter(File::isDirectory).toList()).getOrElse(Collections::emptyList);
    }

    File getProfileContainerFolder(ContainerType type, String folderName) {
        File folder = new File(this.getContainerFolder(type), folderName);
        if (!folder.exists() && !folder.mkdirs()) {
            InvLogging.severe("Could not create profile container folder!", new Object[0]);
        }
        return folder;
    }

    List<File> listPlayerProfileFiles(ContainerType type, String dataName) {
        return (List)Option.of((Object)this.getProfileContainerFolder(type, dataName).listFiles()).map(filesList -> Arrays.stream(filesList).filter(File::isFile).toList()).getOrElse(Collections::emptyList);
    }

    File getPlayerProfileFile(ProfileFileKey profileKey) {
        return this.getPlayerProfileFile(profileKey.getContainerType(), profileKey.getDataName(), profileKey.getPlayerName());
    }

    File getPlayerProfileFile(ContainerType type, String dataName, String playerName) {
        File jsonPlayerFile = new File(this.getProfileContainerFolder(type, dataName), playerName + JSON);
        InvLogging.finer("got data file: %s. Type: %s, DataName: %s, PlayerName: %s", new Object[]{jsonPlayerFile.getPath(), type, dataName, playerName});
        return jsonPlayerFile;
    }

    File getGlobalFolder() {
        return this.globalFolder;
    }

    List<File> listGlobalFiles() {
        return (List)Option.of((Object)this.globalFolder.listFiles()).map(filesList -> Arrays.stream(filesList).filter(File::isFile).toList()).getOrElse(Collections::emptyList);
    }

    File getGlobalFile(UUID playerUUID) {
        return this.getGlobalFile(playerUUID.toString());
    }

    File getGlobalFile(String playerIdentifier) {
        return new File(this.globalFolder, playerIdentifier + JSON);
    }
}

