/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.listeners;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventMethod;
import org.mvplugins.multiverse.core.event.MVConfigReloadEvent;
import org.mvplugins.multiverse.core.event.MVDebugModeEvent;
import org.mvplugins.multiverse.core.event.MVDumpsDebugInfoEvent;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.config.InventoriesConfig;
import org.mvplugins.multiverse.inventories.listeners.MVInvListener;
import org.mvplugins.multiverse.inventories.profile.ProfileCacheManager;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

@Service
final class MVEventsListener
implements MVInvListener {
    private final MultiverseInventories inventories;
    private final InventoriesConfig config;
    private final WorldGroupManager worldGroupManager;
    private final ProfileCacheManager profileCacheManager;

    @Inject
    MVEventsListener(@NotNull MultiverseInventories inventories, @NotNull InventoriesConfig config, @NotNull WorldGroupManager worldGroupManager, @NotNull ProfileCacheManager profileCacheManager) {
        this.inventories = inventories;
        this.config = config;
        this.worldGroupManager = worldGroupManager;
        this.profileCacheManager = profileCacheManager;
    }

    @EventMethod
    void dumpsDebugInfoRequest(MVDumpsDebugInfoEvent event) {
        event.appendDebugInfo(this.getDebugInfo());
        File configFile = new File(this.inventories.getDataFolder(), "config.yml");
        File groupsFile = new File(this.inventories.getDataFolder(), "groups.yml");
        event.putDetailedDebugInfo("multiverse-inventories/config.yml", configFile);
        event.putDetailedDebugInfo("multiverse-inventories/groups.yml", groupsFile);
        event.putDetailedDebugInfo("multiverse-inventories/cachestats.md", this.generateCacheStatsContent());
    }

    private String generateCacheStatsContent() {
        StringBuilder builder = new StringBuilder();
        this.profileCacheManager.getCacheStats().forEach((cacheName, stats) -> builder.append("# ").append((String)cacheName).append("\n").append("- hits count: ").append(stats.hitCount()).append("\n").append("- misses count: ").append(stats.missCount()).append("\n").append("- loads count: ").append(stats.loadCount()).append("\n").append("- misses count: ").append(stats.missCount()).append("\n").append("- evictions: ").append(stats.evictionCount()).append("\n").append("- hit rate: ").append(stats.hitRate() * 100.0).append("%\n").append("- miss rate: ").append(stats.missRate() * 100.0).append("%\n").append("- avg load penalty: ").append(stats.averageLoadPenalty() / 1000000.0).append("ms\n").append("\n"));
        return builder.toString();
    }

    private String getDebugInfo() {
        StringBuilder versionInfo = new StringBuilder("[Multiverse-Inventories] Multiverse-Inventories Version: " + this.inventories.getDescription().getVersion() + "\n[Multiverse-Inventories] === Settings ===\n[Multiverse-Inventories] First Run: " + this.config.getFirstRun() + "\n[Multiverse-Inventories] Using Bypass: " + this.config.getEnableBypassPermissions() + "\n[Multiverse-Inventories] Default Ungrouped Worlds: " + this.config.getDefaultUngroupedWorlds() + "\n[Multiverse-Inventories] Save and Load on Log In and Out: " + this.config.getApplyPlayerdataOnJoin() + "\n[Multiverse-Inventories] Using GameMode Profiles: " + this.config.getEnableGamemodeShareHandling() + "\n[Multiverse-Inventories] === Shares ===\n[Multiverse-Inventories] Optionals for Ungrouped Worlds: " + this.config.getUseOptionalsForUngroupedWorlds() + "\n[Multiverse-Inventories] Enabled Optionals: " + String.valueOf(this.config.getActiveOptionalShares()) + "\n[Multiverse-Inventories] === Groups ===\n");
        for (WorldGroup group : this.worldGroupManager.getGroups()) {
            versionInfo.append("[Multiverse-Inventories] ").append(group.toString()).append('\n');
        }
        return versionInfo.toString();
    }

    @EventMethod
    void onDebugModeChange(MVDebugModeEvent event) {
        InvLogging.setDebugLevel(event.getLevel());
    }

    @EventMethod
    void configReload(MVConfigReloadEvent event) {
        this.inventories.reloadConfig();
        event.addConfig("Multiverse-Inventories - config.yml");
    }
}

