/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.destination;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.mvplugins.multiverse.core.destination.Destination;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.inventories.destination.LastLocationDestination;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainerStoreProvider;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

public final class LastLocationDestinationInstance
extends DestinationInstance<LastLocationDestinationInstance, LastLocationDestination> {
    private final WorldGroupManager worldGroupManager;
    private final ProfileContainerStoreProvider profileContainerStoreProvider;
    private final String worldName;

    LastLocationDestinationInstance(@NotNull LastLocationDestination destination, @NotNull WorldGroupManager worldGroupManager, @NotNull ProfileContainerStoreProvider profileContainerStoreProvider, @NotNull String worldName) {
        super((Destination)destination);
        this.worldGroupManager = worldGroupManager;
        this.profileContainerStoreProvider = profileContainerStoreProvider;
        this.worldName = worldName;
    }

    @NotNull
    public Option<Location> getLocation(@NotNull Entity teleportee) {
        InvLogging.warning("LastLocationDestination: teleportee: " + String.valueOf(teleportee), new Object[0]);
        if (!(teleportee instanceof Player)) {
            return Option.none();
        }
        Player player = (Player)teleportee;
        String playerWorld = player.getWorld().getName();
        if (playerWorld.equals(this.worldName)) {
            return Option.none();
        }
        for (WorldGroup group : this.worldGroupManager.getGroupsForWorld(this.worldName)) {
            InvLogging.warning("LastLocationDestination: group: " + String.valueOf(group), new Object[0]);
            if (group.containsWorld(playerWorld) || !group.getApplicableShares().contains(Sharables.LAST_LOCATION)) continue;
            return Option.of((Object)this.profileContainerStoreProvider.getStore(ContainerType.GROUP).getContainer(group.getName()).getPlayerProfileNow(player).get(Sharables.LAST_LOCATION));
        }
        return Option.of((Object)this.profileContainerStoreProvider.getStore(ContainerType.WORLD).getContainer(this.worldName).getPlayerProfileNow(player).get(Sharables.LAST_LOCATION));
    }

    @NotNull
    public Option<Vector> getVelocity(@NotNull Entity teleportee) {
        return Option.none();
    }

    public boolean checkTeleportSafety() {
        return false;
    }

    @NotNull
    public Option<String> getFinerPermissionSuffix() {
        return Option.of((Object)this.worldName);
    }

    @NotNull
    protected String serialise() {
        return this.worldName;
    }
}

