/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.destination;

import java.util.Collection;
import org.bukkit.command.CommandSender;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.destination.Destination;
import org.mvplugins.multiverse.core.destination.DestinationSuggestionPacket;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.core.utils.result.FailureReason;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.acf.locales.MessageKey;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.inventories.destination.LastLocationDestinationInstance;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainerStoreProvider;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;

@Service
public final class LastLocationDestination
implements Destination<LastLocationDestination, LastLocationDestinationInstance, InstanceFailureReason> {
    private final WorldManager worldManager;
    private final WorldGroupManager worldGroupManager;
    private final ProfileContainerStoreProvider profileContainerStoreProvider;

    @Inject
    LastLocationDestination(@NotNull WorldManager worldManager, @NotNull WorldGroupManager worldGroupManager, @NotNull ProfileContainerStoreProvider profileContainerStoreProvider) {
        this.worldManager = worldManager;
        this.worldGroupManager = worldGroupManager;
        this.profileContainerStoreProvider = profileContainerStoreProvider;
    }

    @NotNull
    public String getIdentifier() {
        return "ll";
    }

    @NotNull
    public Attempt<LastLocationDestinationInstance, InstanceFailureReason> getDestinationInstance(@NotNull String destinationParams) {
        if (!this.worldManager.isLoadedWorld(destinationParams)) {
            return Attempt.failure((FailureReason)InstanceFailureReason.WORLD_NOT_FOUND, (MessageReplacement[])new MessageReplacement[0]);
        }
        return Attempt.success((Object)((Object)new LastLocationDestinationInstance(this, this.worldGroupManager, this.profileContainerStoreProvider, destinationParams)));
    }

    @NotNull
    public Collection<DestinationSuggestionPacket> suggestDestinations(@NotNull CommandSender commandSender, @Nullable String destinationParams) {
        return this.worldManager.getLoadedWorlds().stream().map(world -> new DestinationSuggestionPacket((Destination)this, world.getName(), world.getName())).toList();
    }

    public static enum InstanceFailureReason implements FailureReason
    {
        WORLD_NOT_FOUND((MessageKeyProvider)MVCorei18n.DESTINATION_SHARED_FAILUREREASON_WORLDNOTFOUND);

        private final MessageKeyProvider messageKey;

        private InstanceFailureReason(MessageKeyProvider message) {
            this.messageKey = message;
        }

        public MessageKey getMessageKey() {
            return this.messageKey.getMessageKey();
        }
    }
}

