/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.config;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.config.handle.BaseConfigurationHandle;
import org.mvplugins.multiverse.core.config.handle.CommentedConfigurationHandle;
import org.mvplugins.multiverse.core.config.handle.StringPropertyHandle;
import org.mvplugins.multiverse.core.config.migration.ConfigMigrator;
import org.mvplugins.multiverse.core.config.migration.VersionMigrator;
import org.mvplugins.multiverse.core.config.migration.action.MigratorAction;
import org.mvplugins.multiverse.core.config.migration.action.MoveMigratorAction;
import org.mvplugins.multiverse.core.config.node.NodeGroup;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.vavr.control.Try;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.config.InventoriesConfigNodes;
import org.mvplugins.multiverse.inventories.share.Shares;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

@Service
public final class InventoriesConfig {
    public static final String CONFIG_FILENAME = "config.yml";
    private final InventoriesConfigNodes configNodes = new InventoriesConfigNodes();
    private final CommentedConfigurationHandle configHandle;
    private final StringPropertyHandle stringPropertyHandle;

    @Inject
    InventoriesConfig(MultiverseInventories inventories) throws IOException {
        Path configPath = Path.of(inventories.getDataFolder().getPath(), CONFIG_FILENAME);
        this.configHandle = ((CommentedConfigurationHandle.Builder)((CommentedConfigurationHandle.Builder)CommentedConfigurationHandle.builder((Path)configPath, (NodeGroup)this.configNodes.getNodes()).logger(InvLogging.getLogger())).migrator(ConfigMigrator.builder(this.configNodes.version).addVersionMigrator(VersionMigrator.builder((double)5.0).addAction((MigratorAction)MoveMigratorAction.of((String)"settings.first_run", (String)"first-run")).addAction((MigratorAction)MoveMigratorAction.of((String)"settings.use_bypass", (String)"share-handling.enable-bypass-permissions")).addAction((MigratorAction)MoveMigratorAction.of((String)"settings.default_ungrouped_worlds", (String)"share-handling.default-ungrouped-worlds")).addAction((MigratorAction)MoveMigratorAction.of((String)"settings.save_load_on_log_in_out", (String)"performance.apply-playerdata-on-join")).addAction((MigratorAction)MoveMigratorAction.of((String)"settings.use_game_mode_profiles", (String)"share-handling.enable-gamemode-share-handling")).addAction((MigratorAction)MoveMigratorAction.of((String)"shares.optionals_for_ungrouped_worlds", (String)"share-handling.use-optionals-for-ungrouped-worlds")).addAction((MigratorAction)MoveMigratorAction.of((String)"shares.use_optionals", (String)"share-handling.active-optional-shares")).build()).build())).build();
        this.stringPropertyHandle = new StringPropertyHandle((BaseConfigurationHandle)this.configHandle);
    }

    public Try<Void> load() {
        return this.configHandle.load();
    }

    public FileConfiguration getConfig() {
        return (FileConfiguration)this.configHandle.getConfig();
    }

    public StringPropertyHandle getStringPropertyHandle() {
        return this.stringPropertyHandle;
    }

    public boolean getEnableBypassPermissions() {
        return (Boolean)this.configHandle.get(this.configNodes.enableBypassPermissions);
    }

    public Try<Void> setEnableBypassPermissions(boolean useBypass) {
        return this.configHandle.set(this.configNodes.enableBypassPermissions, (Object)useBypass);
    }

    public boolean getEnableGamemodeShareHandling() {
        return (Boolean)this.configHandle.get(this.configNodes.enableGamemodeShareHandling);
    }

    public Try<Void> setEnableGamemodeShareHandling(boolean useGameModeProfile) {
        return this.configHandle.set(this.configNodes.enableGamemodeShareHandling, (Object)useGameModeProfile);
    }

    public boolean getDefaultUngroupedWorlds() {
        return (Boolean)this.configHandle.get(this.configNodes.defaultUngroupedWorlds);
    }

    public Try<Void> setDefaultUngroupedWorlds(boolean useDefaultGroup) {
        return this.configHandle.set(this.configNodes.defaultUngroupedWorlds, (Object)useDefaultGroup);
    }

    public boolean getUseOptionalsForUngroupedWorlds() {
        return (Boolean)this.configHandle.get(this.configNodes.useOptionalsForUngroupedWorlds);
    }

    public Try<Void> setUseOptionalsForUngroupedWorlds(boolean usingOptionalsForUngrouped) {
        return this.configHandle.set(this.configNodes.useOptionalsForUngroupedWorlds, (Object)usingOptionalsForUngrouped);
    }

    public Shares getActiveOptionalShares() {
        return (Shares)this.configHandle.get(this.configNodes.activeOptionalShares);
    }

    public Try<Void> setActiveOptionalShares(Shares shares) {
        return this.configHandle.set(this.configNodes.activeOptionalShares, (Object)shares);
    }

    public boolean getUseImprovedRespawnLocationDetection() {
        return (Boolean)this.configHandle.get(this.configNodes.useImprovedRespawnLocationDetection);
    }

    public Try<Void> setUseImprovedRespawnLocationDetection(boolean useImprovedRespawnLocationDetection) {
        return this.configHandle.set(this.configNodes.useImprovedRespawnLocationDetection, (Object)useImprovedRespawnLocationDetection);
    }

    public boolean getResetLastLocationOnDeath() {
        return (Boolean)this.configHandle.get(this.configNodes.resetLastLocationOnDeath);
    }

    public Try<Void> setResetLastLocationOnDeath(boolean resetLastLocationOnDeath) {
        return this.configHandle.set(this.configNodes.resetLastLocationOnDeath, (Object)resetLastLocationOnDeath);
    }

    public boolean getApplyLastLocationForAllTeleports() {
        return (Boolean)this.configHandle.get(this.configNodes.applyLastLocationForAllTeleports);
    }

    public Try<Void> setApplyLastLocationForAllTeleports(boolean applyLastLocationForAllTeleports) {
        return this.configHandle.set(this.configNodes.applyLastLocationForAllTeleports, (Object)applyLastLocationForAllTeleports);
    }

    public boolean getUseByteSerializationForInventoryData() {
        return (Boolean)this.configHandle.get(this.configNodes.useByteSerializationForInventoryData);
    }

    public Try<Void> setUseByteSerializationForInventoryData(boolean useByteSerializationForInventoryData) {
        return this.configHandle.set(this.configNodes.useByteSerializationForInventoryData, (Object)useByteSerializationForInventoryData);
    }

    public boolean getApplyPlayerdataOnJoin() {
        return (Boolean)this.configHandle.get(this.configNodes.applyPlayerdataOnJoin);
    }

    public Try<Void> setApplyPlayerdataOnJoin(boolean applyPlayerdataOnJoin) {
        return this.configHandle.set(this.configNodes.applyPlayerdataOnJoin, (Object)applyPlayerdataOnJoin);
    }

    public boolean getAlwaysWriteWorldProfile() {
        return (Boolean)this.configHandle.get(this.configNodes.alwaysWriteWorldProfile);
    }

    public Try<Void> setAlwaysWriteWorldProfile(boolean alwaysWriteWorldProfile) {
        return this.configHandle.set(this.configNodes.alwaysWriteWorldProfile, (Object)alwaysWriteWorldProfile);
    }

    public List<String> getPreloadDataOnJoinWorlds() {
        return (List)this.configHandle.get(this.configNodes.preloadDataOnJoinWorlds);
    }

    public Try<Void> setPreloadDataOnJoinWorlds(List<String> preloadDataOnJoinWorlds) {
        return this.configHandle.set(this.configNodes.preloadDataOnJoinWorlds, preloadDataOnJoinWorlds);
    }

    public List<String> getPreloadDataOnJoinGroups() {
        return (List)this.configHandle.get(this.configNodes.preloadDataOnJoinGroups);
    }

    public Try<Void> setPreloadDataOnJoinGroups(List<String> preloadDataOnJoinGroups) {
        return this.configHandle.set(this.configNodes.preloadDataOnJoinGroups, preloadDataOnJoinGroups);
    }

    public int getPlayerFileCacheSize() {
        return (Integer)this.configHandle.get(this.configNodes.playerFileCacheSize);
    }

    public Try<Void> setPlayerFileCacheSize(int playerFileCacheSize) {
        return this.configHandle.set(this.configNodes.playerFileCacheSize, (Object)playerFileCacheSize);
    }

    public int getPlayerFileCacheExpiry() {
        return (Integer)this.configHandle.get(this.configNodes.playerFileCacheExpiry);
    }

    public Try<Void> setPlayerFileCacheExpiry(int playerFileCacheExpiry) {
        return this.configHandle.set(this.configNodes.playerFileCacheExpiry, (Object)playerFileCacheExpiry);
    }

    public int getPlayerProfileCacheSize() {
        return (Integer)this.configHandle.get(this.configNodes.playerProfileCacheSize);
    }

    public Try<Void> setPlayerProfileCacheSize(int playerProfileCacheSize) {
        return this.configHandle.set(this.configNodes.playerProfileCacheSize, (Object)playerProfileCacheSize);
    }

    public int getPlayerProfileCacheExpiry() {
        return (Integer)this.configHandle.get(this.configNodes.playerProfileCacheExpiry);
    }

    public Try<Void> setPlayerProfileCacheExpiry(int playerProfileCacheExpiry) {
        return this.configHandle.set(this.configNodes.playerProfileCacheExpiry, (Object)playerProfileCacheExpiry);
    }

    public int getGlobalProfileCacheSize() {
        return (Integer)this.configHandle.get(this.configNodes.globalProfileCacheSize);
    }

    public Try<Void> setGlobalProfileCacheSize(int globalProfileCacheSize) {
        return this.configHandle.set(this.configNodes.globalProfileCacheSize, (Object)globalProfileCacheSize);
    }

    public int getGlobalProfileCacheExpiry() {
        return (Integer)this.configHandle.get(this.configNodes.globalProfileCacheExpiry);
    }

    public Try<Void> setGlobalProfileCacheExpiry(int globalProfileCacheExpiry) {
        return this.configHandle.set(this.configNodes.globalProfileCacheExpiry, (Object)globalProfileCacheExpiry);
    }

    public boolean getFirstRun() {
        return (Boolean)this.configHandle.get(this.configNodes.firstRun);
    }

    public Try<Void> setFirstRun(boolean firstRun) {
        return this.configHandle.set(this.configNodes.firstRun, (Object)firstRun);
    }

    public Try<Void> save() {
        return this.configHandle.save();
    }
}

