/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands.prompts;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.commands.prompts.InventoriesPrompt;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.util.MVInvi18n;

final class GroupWorldsPrompt
extends InventoriesPrompt {
    protected final WorldGroup group;
    protected final Prompt nextPrompt;
    protected final boolean isCreating;
    protected final Set<String> worlds;

    public GroupWorldsPrompt(MultiverseInventories plugin, MVCommandIssuer issuer, WorldGroup group, Prompt nextPrompt, boolean creatingGroup) {
        super(plugin, issuer);
        this.group = group;
        this.nextPrompt = nextPrompt;
        this.isCreating = creatingGroup;
        this.worlds = new HashSet<String>(group.getWorlds());
    }

    @Override
    @NotNull
    public Message getPromptMessage(@NotNull ConversationContext conversationContext) {
        StringBuilder builder = new StringBuilder();
        for (String world : this.worlds) {
            if (builder.length() == 0) {
                builder.append(ChatColor.WHITE);
            } else {
                builder.append(ChatColor.GOLD).append(", ").append(ChatColor.WHITE);
            }
            builder.append(world);
        }
        return Message.of((MessageKeyProvider)MVInvi18n.GROUP_WORLDSPROMPT, (MessageReplacement[])new MessageReplacement[]{MessageReplacement.replace((String)"{group}").with((Object)this.group.getName()), MessageReplacement.replace((String)"{worlds}").with((Object)builder.toString())});
    }

    public Prompt acceptInput(@NotNull ConversationContext conversationContext, String input) {
        if (input.equals("@")) {
            if (this.worlds.isEmpty()) {
                this.issuer.sendInfo((MessageKeyProvider)MVInvi18n.GROUP_WORLDSEMPTY);
                return this;
            }
            this.group.removeAllWorlds(false);
            this.group.addWorlds(this.worlds, false);
            if (!this.isCreating) {
                this.worldGroupManager.updateGroup(this.group);
                this.issuer.sendInfo((MessageKeyProvider)MVInvi18n.GROUP_UPDATED);
                this.issuer.sendInfo((MessageKeyProvider)MVInvi18n.INFO_GROUP, new MessageReplacement[]{MessageReplacement.replace((String)"{group}").with((Object)this.group.getName())});
                this.issuer.sendInfo((MessageKeyProvider)MVInvi18n.INFO_GROUP_INFO, new MessageReplacement[]{MessageReplacement.replace((String)"{worlds}").with(this.group.getWorlds())});
                this.issuer.sendInfo((MessageKeyProvider)MVInvi18n.INFO_GROUP_INFOSHARES, new MessageReplacement[]{MessageReplacement.replace((String)"{shares}").with((Object)this.group.getShares())});
            }
            return this.nextPrompt;
        }
        boolean negative = false;
        World world = Bukkit.getWorld((String)input);
        if (world == null && input.startsWith("-") && input.length() > 1) {
            negative = true;
            world = Bukkit.getWorld((String)input.substring(1));
        }
        if (world == null) {
            this.issuer.sendError((MessageKeyProvider)MVInvi18n.ERROR_NOWORLD, new MessageReplacement[]{MessageReplacement.replace((String)"{world}").with((Object)input)});
            return this;
        }
        if (negative) {
            if (!this.worlds.contains(world.getName())) {
                this.issuer.sendError((MessageKeyProvider)MVInvi18n.REMOVEWORLD_WORLDNOTINGROUP, new MessageReplacement[]{MessageReplacement.replace((String)"{world}").with((Object)input), MessageReplacement.replace((String)"{group}").with((Object)this.group.getName())});
                return this;
            }
            this.worlds.remove(world.getName());
            return this;
        }
        this.worlds.add(world.getName());
        return this;
    }
}

