/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands.prompts;

import org.bukkit.ChatColor;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.commands.prompts.GroupModifyPrompt;
import org.mvplugins.multiverse.inventories.commands.prompts.InventoriesPrompt;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.util.MVInvi18n;

final class GroupEditPrompt
extends InventoriesPrompt {
    public GroupEditPrompt(MultiverseInventories plugin, MVCommandIssuer issuer) {
        super(plugin, issuer);
    }

    @Override
    @NotNull
    public Message getPromptMessage(@NotNull ConversationContext conversationContext) {
        StringBuilder builder = new StringBuilder();
        for (WorldGroup group : this.worldGroupManager.getGroups()) {
            if (builder.isEmpty()) {
                builder.append(ChatColor.WHITE);
            } else {
                builder.append(ChatColor.GOLD).append(", ").append(ChatColor.WHITE);
            }
            builder.append(group.getName());
        }
        return Message.of((MessageKeyProvider)MVInvi18n.GROUP_EDITPROMPT, (MessageReplacement[])new MessageReplacement[]{MessageReplacement.replace((String)"{groups}").with((Object)builder.toString())});
    }

    public Prompt acceptInput(@NotNull ConversationContext conversationContext, String input) {
        WorldGroup group = this.worldGroupManager.getGroup(input);
        if (group != null) {
            return new GroupModifyPrompt(this.plugin, this.issuer, group);
        }
        this.issuer.sendError((MessageKeyProvider)MVInvi18n.ERROR_NOGROUP, new MessageReplacement[]{MessageReplacement.replace((String)"{group}").with((Object)input)});
        return Prompt.END_OF_CONVERSATION;
    }
}

