/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands.prompts;

import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.commands.prompts.GroupSharesPrompt;
import org.mvplugins.multiverse.inventories.commands.prompts.GroupWorldsPrompt;
import org.mvplugins.multiverse.inventories.commands.prompts.InventoriesPrompt;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.util.MVInvi18n;

final class GroupCreatePrompt
extends InventoriesPrompt {
    public GroupCreatePrompt(MultiverseInventories plugin, MVCommandIssuer issuer) {
        super(plugin, issuer);
    }

    @Override
    @NotNull
    Message getPromptMessage(@NotNull ConversationContext conversationContext) {
        return Message.of((MessageKeyProvider)MVInvi18n.GROUP_CREATEPROMPT, (MessageReplacement[])new MessageReplacement[0]);
    }

    public Prompt acceptInput(@NotNull ConversationContext conversationContext, String s) {
        WorldGroup group = this.worldGroupManager.getGroup(s);
        if (group == null) {
            if (s.isEmpty() || !s.matches("^[a-zA-Z0-9][a-zA-Z0-9_]*$")) {
                this.issuer.sendError((MessageKeyProvider)MVInvi18n.GROUP_INVALIDNAME);
                return this;
            }
            WorldGroup newGroup = this.worldGroupManager.newEmptyGroup(s);
            return new GroupWorldsPrompt(this.plugin, this.issuer, newGroup, new GroupSharesPrompt(this.plugin, this.issuer, newGroup, Prompt.END_OF_CONVERSATION, true), true);
        }
        this.issuer.sendError((MessageKeyProvider)MVInvi18n.GROUP_EXISTS, new MessageReplacement[]{MessageReplacement.replace((String)"{group}").with((Object)s)});
        return Prompt.END_OF_CONVERSATION;
    }
}

