/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands;

import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.commands.InventoriesCommand;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.share.Shares;
import org.mvplugins.multiverse.inventories.util.MVInvi18n;

@Service
final class RemoveSharesCommand
extends InventoriesCommand {
    private final WorldGroupManager worldGroupManager;

    @Inject
    RemoveSharesCommand(@NotNull WorldGroupManager worldGroupManager) {
        this.worldGroupManager = worldGroupManager;
    }

    @Subcommand(value="remove-shares")
    @CommandPermission(value="multiverse.inventories.removeshares")
    @CommandCompletion(value="@worldGroups @shares")
    @Syntax(value="<group> <share[,extra]>")
    @Description(value="Remove one or more shares from a group.")
    void onRemoveSharesCommand(MVCommandIssuer issuer, @Syntax(value="<group>") @Description(value="Group you want to remove the shares from.") WorldGroup group, @Syntax(value="<share[,extra]>") @Description(value="One or more sharables to remove.") Shares shares) {
        group.getShares().setSharing(shares, false);
        this.worldGroupManager.updateGroup(group);
        Shares negativeshares = Sharables.allOf();
        negativeshares.setSharing(group.getShares(), false);
        issuer.sendInfo((MessageKeyProvider)MVInvi18n.SHARES_NOWSHARING, new MessageReplacement[]{MessageReplacement.replace((String)"{group}").with((Object)group.getName()), MessageReplacement.replace((String)"{shares}").with(group.getShares().toStringList()), MessageReplacement.replace((String)"{negativeshares}").with(negativeshares.toStringList())});
    }
}

