/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.world.options;

import java.util.Collections;
import java.util.List;
import org.bukkit.block.Biome;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.options.KeepWorldSettingsOptions;
import org.mvplugins.multiverse.external.acf.commands.ACFUtil;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;

public final class RegenWorldOptions
implements KeepWorldSettingsOptions {
    private static final long UNINITIALIZED_SEED_VALUE = Long.MIN_VALUE;
    private final LoadedMultiverseWorld world;
    private Biome biome;
    private boolean keepGameRule = true;
    private boolean keepWorldConfig = true;
    private boolean keepWorldBorder = true;
    private boolean randomSeed = false;
    private long seed = Long.MIN_VALUE;
    private List<String> keepFiles = Collections.emptyList();

    @NotNull
    public static RegenWorldOptions world(@NotNull LoadedMultiverseWorld world) {
        return new RegenWorldOptions(world);
    }

    RegenWorldOptions(@NotNull LoadedMultiverseWorld world) {
        this.world = world;
    }

    private boolean isSeedInitialized() {
        return this.seed != Long.MIN_VALUE;
    }

    @NotNull
    public LoadedMultiverseWorld world() {
        return this.world;
    }

    @NotNull
    public RegenWorldOptions biome(@Nullable Biome biome) {
        this.biome = biome;
        return this;
    }

    @NotNull
    public Biome biome() {
        return this.biome;
    }

    @Override
    @NotNull
    public RegenWorldOptions keepGameRule(boolean keepGameRuleInput) {
        this.keepGameRule = keepGameRuleInput;
        return this;
    }

    @Override
    public boolean keepGameRule() {
        return this.keepGameRule;
    }

    @Override
    @NotNull
    public RegenWorldOptions keepWorldConfig(boolean keepWorldConfigInput) {
        this.keepWorldConfig = keepWorldConfigInput;
        return this;
    }

    @Override
    public boolean keepWorldConfig() {
        return this.keepWorldConfig;
    }

    @Override
    @NotNull
    public RegenWorldOptions keepWorldBorder(boolean keepWorldBorderInput) {
        this.keepWorldBorder = keepWorldBorderInput;
        return this;
    }

    @Override
    public boolean keepWorldBorder() {
        return this.keepWorldBorder;
    }

    @NotNull
    public RegenWorldOptions randomSeed(boolean randomSeedInput) {
        if (randomSeedInput && this.isSeedInitialized()) {
            throw new IllegalStateException("Cannot set randomSeed to true when seed is set");
        }
        this.randomSeed = randomSeedInput;
        return this;
    }

    public boolean randomSeed() {
        return this.randomSeed;
    }

    @NotNull
    public RegenWorldOptions seed(@Nullable String seedInput) {
        if (seedInput == null) {
            this.seed = Long.MIN_VALUE;
            return this;
        }
        if (this.randomSeed) {
            this.randomSeed(false);
        }
        this.seed = this.parseOrHashSeed(seedInput);
        return this;
    }

    private long parseOrHashSeed(String seedInput) {
        try {
            return Long.parseLong(seedInput);
        }
        catch (NumberFormatException numberformatexception) {
            return seedInput.hashCode();
        }
    }

    @NotNull
    public RegenWorldOptions seed(long seedInput) {
        this.seed = seedInput;
        return this;
    }

    public long seed() {
        if (this.randomSeed) {
            return ACFUtil.RANDOM.nextLong();
        }
        if (this.isSeedInitialized()) {
            return this.seed;
        }
        return this.world.getSeed();
    }

    @NotNull
    public RegenWorldOptions keepFiles(@Nullable List<String> keepFilesInput) {
        this.keepFiles = keepFilesInput == null ? Collections.emptyList() : keepFilesInput.stream().toList();
        return this;
    }

    @NotNull
    public List<String> keepFiles() {
        return this.keepFiles;
    }
}

