/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.world.entrycheck;

import java.util.Collection;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.economy.MVEconomist;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.permissions.CorePermissionsChecker;
import org.mvplugins.multiverse.core.utils.result.Result;
import org.mvplugins.multiverse.core.utils.result.ResultChain;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.entrycheck.BlacklistResult;
import org.mvplugins.multiverse.core.world.entrycheck.EntryFeeResult;
import org.mvplugins.multiverse.core.world.entrycheck.PlayerLimitResult;
import org.mvplugins.multiverse.core.world.entrycheck.WorldAccessResult;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;

public final class WorldEntryChecker {
    @NotNull
    private final CoreConfig config;
    @NotNull
    private final MVEconomist economist;
    @NotNull
    private final CorePermissionsChecker permissionsChecker;
    @NotNull
    private final CommandSender sender;

    WorldEntryChecker(@NotNull CoreConfig config, @NotNull CorePermissionsChecker permissionsChecker, @NotNull MVEconomist economist, @NotNull CommandSender sender) {
        this.config = config;
        this.permissionsChecker = permissionsChecker;
        this.economist = economist;
        this.sender = sender;
    }

    public ResultChain canStayInWorld(@NotNull LoadedMultiverseWorld world) {
        return ResultChain.builder().then(() -> this.canAccessWorld(world)).then(() -> this.isWithinPlayerLimit(world)).build();
    }

    public ResultChain canEnterWorld(@Nullable MultiverseWorld fromWorld, @NotNull LoadedMultiverseWorld toWorld) {
        return ResultChain.builder().then(() -> this.canAccessWorld(toWorld)).then(() -> this.isWithinPlayerLimit(toWorld)).then(() -> this.isNotBlacklisted(fromWorld, toWorld)).then(() -> this.canPayEntryFee(toWorld)).build();
    }

    public Result<WorldAccessResult.Success, WorldAccessResult.Failure> canAccessWorld(@NotNull MultiverseWorld world) {
        if (!this.config.getEnforceAccess()) {
            return Result.success(WorldAccessResult.Success.NO_ENFORCE_WORLD_ACCESS, new MessageReplacement[0]);
        }
        return this.permissionsChecker.hasWorldAccessPermission(this.sender, world) ? Result.success(WorldAccessResult.Success.HAS_WORLD_ACCESS, new MessageReplacement[0]) : Result.failure(WorldAccessResult.Failure.NO_WORLD_ACCESS, new MessageReplacement[0]);
    }

    public Result<PlayerLimitResult.Success, PlayerLimitResult.Failure> isWithinPlayerLimit(@NotNull LoadedMultiverseWorld world) {
        int playerLimit = world.getPlayerLimit();
        if (playerLimit <= -1) {
            return Result.success(PlayerLimitResult.Success.NO_PLAYERLIMIT, new MessageReplacement[0]);
        }
        if (this.permissionsChecker.hasPlayerLimitBypassPermission(this.sender, world)) {
            return Result.success(PlayerLimitResult.Success.BYPASS_PLAYERLIMIT, new MessageReplacement[0]);
        }
        int numberOfPlayersInWorld = world.getBukkitWorld().map(World::getPlayers).map(Collection::size).getOrElse(0);
        return playerLimit > numberOfPlayersInWorld ? Result.success(PlayerLimitResult.Success.WITHIN_PLAYERLIMIT, new MessageReplacement[0]) : Result.failure(PlayerLimitResult.Failure.EXCEED_PLAYERLIMIT, new MessageReplacement[0]);
    }

    public Result<BlacklistResult.Success, BlacklistResult.Failure> isNotBlacklisted(@Nullable MultiverseWorld fromWorld, @NotNull MultiverseWorld toWorld) {
        if (fromWorld == null) {
            return Result.success(BlacklistResult.Success.UNKNOWN_FROM_WORLD, new MessageReplacement[0]);
        }
        return toWorld.getWorldBlacklist().contains(fromWorld.getName()) ? Result.failure(BlacklistResult.Failure.BLACKLISTED, MessageReplacement.Replace.WORLD.with(fromWorld.getAliasOrName())) : Result.success(BlacklistResult.Success.NOT_BLACKLISTED, new MessageReplacement[0]);
    }

    public Result<EntryFeeResult.Success, EntryFeeResult.Failure> canPayEntryFee(MultiverseWorld world) {
        double price = world.getPrice();
        if (!world.isEntryFeeEnabled() || price == 0.0) {
            return Result.success(EntryFeeResult.Success.FREE_ENTRY, new MessageReplacement[0]);
        }
        if (this.sender instanceof ConsoleCommandSender || this.sender instanceof BlockCommandSender) {
            return Result.success(EntryFeeResult.Success.CONSOLE_OR_BLOCK_COMMAND_SENDER, new MessageReplacement[0]);
        }
        if (this.permissionsChecker.hasWorldExemptPermission(this.sender, world)) {
            return Result.success(EntryFeeResult.Success.EXEMPT_FROM_ENTRY_FEE, new MessageReplacement[0]);
        }
        CommandSender commandSender = this.sender;
        if (!(commandSender instanceof Player)) {
            return Result.failure(EntryFeeResult.Failure.CANNOT_PAY_ENTRY_FEE, new MessageReplacement[0]);
        }
        Player player = (Player)commandSender;
        Material currency = world.getCurrency();
        return this.economist.isPlayerWealthyEnough(player, price, currency) ? Result.success(EntryFeeResult.Success.ENOUGH_MONEY, new MessageReplacement[0]) : Result.failure(EntryFeeResult.Failure.NOT_ENOUGH_MONEY, MessageReplacement.replace("{amount}").with(this.economist.formatPrice(price, currency)));
    }
}

