/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils.webpaste;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.mvplugins.multiverse.core.utils.webpaste.HttpAPIClient;
import org.mvplugins.multiverse.core.utils.webpaste.PasteFailedException;
import org.mvplugins.multiverse.core.utils.webpaste.PasteService;
import org.mvplugins.multiverse.external.minidev.json.JSONObject;
import org.mvplugins.multiverse.external.minidev.json.parser.JSONParser;
import org.mvplugins.multiverse.external.minidev.json.parser.ParseException;

final class McloGsPasteService
extends PasteService {
    private static final String MCLOGS_POST_REQUEST = "https://api.mclo.gs/1/log";

    McloGsPasteService() {
        super(MCLOGS_POST_REQUEST);
    }

    @Override
    String encodeData(String data) {
        return "content=" + URLEncoder.encode(data, StandardCharsets.UTF_8);
    }

    @Override
    String encodeData(Map<String, String> data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String postData(String data) throws PasteFailedException {
        try {
            String stringJSON = this.exec(this.encodeData(data), HttpAPIClient.ContentType.URLENCODED);
            return String.valueOf(((JSONObject)new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(stringJSON)).get("url"));
        }
        catch (IOException | ParseException e) {
            throw new PasteFailedException(e);
        }
    }

    @Override
    public String postData(Map<String, String> data) throws PasteFailedException {
        try {
            String stringJSON = this.exec(this.encodeData(data), HttpAPIClient.ContentType.JSON);
            return String.valueOf(((JSONObject)new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(stringJSON)).get("url"));
        }
        catch (IOException | ParseException e) {
            throw new PasteFailedException(e);
        }
    }

    @Override
    public boolean supportsMultiFile() {
        return false;
    }
}

