/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils.webpaste;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class HttpAPIClient {
    private final String url;
    private final String accessToken;

    HttpAPIClient(String url) {
        this(url, null);
    }

    HttpAPIClient(String url, String accessToken) {
        this.url = url;
        this.accessToken = accessToken;
    }

    private String getContentHeader(ContentType type) {
        return switch (type.ordinal()) {
            case 0 -> "application/json; charset=utf-8";
            case 1 -> "text/plain; charset=utf-8";
            case 2 -> "text/yaml";
            case 3 -> "application/x-www-form-urlencoded; charset=utf-8";
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)type));
        };
    }

    abstract String encodeData(String var1);

    abstract String encodeData(Map<String, String> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String exec(String payload, ContentType type) throws IOException {
        BufferedReader bufferedReader = null;
        OutputStreamWriter streamWriter = null;
        try {
            String line;
            HttpsURLConnection connection = this.getHttpsURLConnection(type);
            streamWriter = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8.newEncoder());
            streamWriter.write(payload);
            streamWriter.flush();
            StringBuilder responseString = new StringBuilder();
            bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            while ((line = bufferedReader.readLine()) != null) {
                responseString.append(line);
            }
            String string = responseString.toString();
            return string;
        }
        finally {
            if (streamWriter != null) {
                try {
                    streamWriter.close();
                }
                catch (IOException iOException) {}
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @NotNull
    private HttpsURLConnection getHttpsURLConnection(ContentType type) throws IOException {
        HttpsURLConnection connection = (HttpsURLConnection)new URL(this.url).openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.addRequestProperty("Accept", "*/*");
        connection.addRequestProperty("User-Agent", "multiverse/dumps");
        connection.addRequestProperty("Content-Type", this.getContentHeader(type));
        if (this.accessToken != null) {
            connection.addRequestProperty("Authorization", this.accessToken);
        }
        return connection;
    }

    static enum ContentType {
        JSON,
        PLAINTEXT,
        PLAINTEXT_YAML,
        URLENCODED;

    }
}

