/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils.result;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.core.utils.result.FailureReason;
import org.mvplugins.multiverse.external.vavr.control.Either;

public final class AsyncAttempt<T, F extends FailureReason> {
    private final CompletableFuture<Attempt<T, F>> future;

    public static <T, F extends FailureReason> AsyncAttempt<T, F> of(CompletableFuture<T> future, BiFunction<T, Throwable, Attempt<T, F>> completionHandler) {
        return new AsyncAttempt<T, F>(future.handle(completionHandler));
    }

    public static <T, F extends FailureReason> AsyncAttempt<T, F> of(CompletableFuture<T> future, Function<Throwable, Attempt<T, F>> exceptionHandler) {
        BiFunction<Object, Throwable, Attempt> completionHandler = (result, exception) -> exception != null ? (Attempt)exceptionHandler.apply((Throwable)exception) : Attempt.success(result);
        return AsyncAttempt.of(future, completionHandler);
    }

    public static <T, F extends FailureReason> AsyncAttempt<T, F> fromAttempt(Attempt<T, F> attempt) {
        return new AsyncAttempt<T, F>(CompletableFuture.completedFuture(attempt));
    }

    public static <F extends FailureReason> AsyncAttempt<Void, F> success() {
        return new AsyncAttempt(CompletableFuture.completedFuture(null));
    }

    public static <F extends FailureReason> AsyncAttempt<Void, F> failure(F failureReason, MessageReplacement ... messageReplacements) {
        return new AsyncAttempt(CompletableFuture.completedFuture(Attempt.failure(failureReason, messageReplacements)));
    }

    private AsyncAttempt(CompletableFuture<Attempt<T, F>> future) {
        this.future = future;
    }

    public AsyncAttempt<T, F> thenRun(Runnable runnable) {
        return new AsyncAttempt<T, F>(this.future.thenApply(attempt -> attempt.thenRun(runnable)));
    }

    public AsyncAttempt<T, F> thenAccept(Consumer<Either<T, F>> consumer) {
        return new AsyncAttempt<T, F>(this.future.thenApply(attempt -> attempt.thenAccept(consumer)));
    }

    public <U> AsyncAttempt<U, F> map(Function<? super T, ? extends U> mapper) {
        return new AsyncAttempt<T, F>(this.future.thenApply(attempt -> attempt.map(mapper)));
    }

    public <U> AsyncAttempt<U, F> mapAttempt(Function<? super T, Attempt<U, F>> mapper) {
        return new AsyncAttempt<T, F>(this.future.thenApply(attempt -> attempt.mapAttempt(mapper)));
    }

    public <U> AsyncAttempt<U, F> mapAsyncAttempt(Function<? super T, AsyncAttempt<U, F>> mapper) {
        return new AsyncAttempt<T, F>(this.future.thenCompose(attempt -> {
            if (attempt.isSuccess()) {
                return ((AsyncAttempt)mapper.apply(attempt.get())).future;
            }
            return CompletableFuture.completedFuture(new Attempt.Failure(attempt.getFailureReason(), attempt.getFailureMessage()));
        }));
    }

    public AsyncAttempt<T, F> onSuccess(Runnable runnable) {
        return new AsyncAttempt<T, F>(this.future.thenApply(attempt -> attempt.onSuccess(runnable)));
    }

    public AsyncAttempt<T, F> onFailure(Runnable runnable) {
        return new AsyncAttempt<T, F>(this.future.thenApply(attempt -> attempt.onFailure(runnable)));
    }

    public AsyncAttempt<T, F> onFailure(Consumer<Attempt.Failure<T, F>> consumer) {
        return new AsyncAttempt<T, F>(this.future.thenApply(attempt -> attempt.onFailure(consumer)));
    }

    public AsyncAttempt<T, F> onFailureReason(Consumer<F> consumer) {
        return new AsyncAttempt<T, F>(this.future.thenApply(attempt -> attempt.onFailureReason(consumer)));
    }

    public Attempt<T, F> toAttempt() {
        return this.future.join();
    }

    CompletableFuture<Attempt<T, F>> getFuture() {
        return this.future;
    }
}

