/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.FileUtils;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Option;

@Service
public final class ServerProperties {
    private final Map<String, String> properties;
    private final FileUtils fileUtils;

    @Inject
    public ServerProperties(@NotNull FileUtils fileUtils) {
        this.fileUtils = fileUtils;
        this.properties = new HashMap<String, String>();
        this.parseServerPropertiesFile();
    }

    private void parseServerPropertiesFile() {
        if (this.fileUtils.getServerProperties() == null) {
            return;
        }
        try {
            Files.readAllLines(this.fileUtils.getServerProperties().toPath()).stream().map(String::strip).filter(line -> !line.startsWith("#")).map(line -> REPatterns.EQUALS.split((CharSequence)line, 2)).filter(line -> ((String[])line).length == 2).forEach(line -> this.properties.put(line[0], line[1]));
        }
        catch (IOException e) {
            CoreLogging.warning("Could not read server.properties file! Some features such as default world may not work as expected.", new Object[0]);
        }
    }

    public Option<String> getLevelName() {
        return this.getProperty("level-name");
    }

    public boolean getAllowNether() {
        return this.getProperty("allow-nether").map(Boolean::parseBoolean).getOrElse(true);
    }

    public Option<String> getProperty(String key) {
        return Option.of(this.properties.get(key));
    }
}

