/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="5.5")
public class CaseInsensitiveStringMap<T>
implements Map<String, T> {
    private final Map<String, T> map = new HashMap<String, T>();

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(this.normalizeKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public T get(Object key) {
        return this.map.get(this.normalizeKey(key));
    }

    @Override
    public @Nullable T put(String key, T value) {
        return this.map.put(this.normalizeKey(key), value);
    }

    @Override
    public T remove(Object key) {
        return this.map.remove(this.normalizeKey(key));
    }

    @Override
    public void putAll(@NonNull Map<? extends String, ? extends T> m) {
        m.forEach((key, value) -> this.map.put(this.normalizeKey(key), value));
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public @NonNull Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public @NonNull Collection<T> values() {
        return this.map.values();
    }

    @Override
    public @NonNull Set<Map.Entry<String, T>> entrySet() {
        return this.map.entrySet();
    }

    private String normalizeKey(Object key) {
        return String.valueOf(key).toLowerCase(Locale.ROOT);
    }
}

