/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.locale.message;

import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.commands.ACFUtil;
import org.mvplugins.multiverse.external.acf.commands.CommandIssuer;
import org.mvplugins.multiverse.external.acf.commands.Locales;
import org.mvplugins.multiverse.external.acf.locales.MessageKey;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;

public final class LocalizedMessage
extends Message
implements MessageKeyProvider {
    @NotNull
    private final MessageKeyProvider messageKeyProvider;

    LocalizedMessage(@NotNull MessageKeyProvider messageKeyProvider, @NotNull String message, MessageReplacement ... replacements) {
        super(message, replacements);
        this.messageKeyProvider = messageKeyProvider;
    }

    @Override
    public MessageKey getMessageKey() {
        return this.messageKeyProvider.getMessageKey();
    }

    @Override
    @NotNull
    public String formatted(@NotNull Locales locales, @Nullable CommandIssuer commandIssuer) {
        String[] parsedReplacements = this.getReplacements(locales, commandIssuer);
        if (parsedReplacements.length == 0) {
            return locales.getMessage(commandIssuer, this.getMessageKey());
        }
        return ACFUtil.replaceStrings(locales.getMessage(commandIssuer, this.getMessageKey()), parsedReplacements);
    }
}

