/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.display.handlers;

import java.util.List;
import org.bukkit.ChatColor;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.display.handlers.BaseSendHandler;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;

public class InlineSendHandler
extends BaseSendHandler<InlineSendHandler> {
    private String delimiter = String.valueOf(ChatColor.WHITE) + ", ";
    private String prefix = null;

    public static InlineSendHandler create() {
        return new InlineSendHandler();
    }

    InlineSendHandler() {
    }

    @Override
    public void sendContent(@NotNull MVCommandIssuer issuer, @NotNull List<String> content) {
        if (this.filter.needToFilter()) {
            issuer.sendMessage(MVCorei18n.CONTENTDISPLAY_FILTER, MessageReplacement.replace("{filter}").with(this.filter));
        }
        Object message = String.join((CharSequence)this.delimiter, content);
        if (this.prefix != null) {
            message = this.prefix + (String)message;
        }
        issuer.sendMessage((String)message);
    }

    public InlineSendHandler withDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public InlineSendHandler withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

