/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.destination.core;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.generator.WorldInfo;
import org.bukkit.util.Vector;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.destination.core.CannonDestination;
import org.mvplugins.multiverse.core.world.location.UnloadedWorldLocation;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.vavr.control.Option;

public final class CannonDestinationInstance
extends DestinationInstance<CannonDestinationInstance, CannonDestination> {
    private final UnloadedWorldLocation location;
    private final double speed;

    CannonDestinationInstance(@NotNull CannonDestination destination, @NotNull UnloadedWorldLocation location, double speed) {
        super(destination);
        this.location = location;
        this.speed = speed;
    }

    @Override
    @NotNull
    public Option<Location> getLocation(@NotNull Entity teleportee) {
        if (this.location.getWorld() == null) {
            return Option.none();
        }
        return Option.of(this.location.toBukkitLocation());
    }

    @Override
    @NotNull
    public Option<Vector> getVelocity(@NotNull Entity teleportee) {
        double pitchRadians = Math.toRadians(this.location.getPitch());
        double yawRadians = Math.toRadians(this.location.getYaw());
        double x = Math.sin(yawRadians) * this.speed * -1.0;
        double y = Math.sin(pitchRadians) * this.speed * -1.0;
        double z = Math.cos(yawRadians) * this.speed;
        x = Math.cos(pitchRadians) * x;
        z = Math.cos(pitchRadians) * z;
        return Option.of(new Vector(x, y, z));
    }

    @Override
    public boolean checkTeleportSafety() {
        return false;
    }

    @Override
    @NotNull
    public Option<String> getFinerPermissionSuffix() {
        return Option.of(this.location.getWorld()).map(WorldInfo::getName);
    }

    @Override
    @NotNull
    public String serialise() {
        return this.location.getWorldName() + ":" + this.location.getX() + "," + this.location.getY() + "," + this.location.getZ() + ":" + this.location.getPitch() + ":" + this.location.getYaw() + ":" + this.speed;
    }
}

