/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.destination;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import org.mvplugins.multiverse.core.destination.Destination;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.vavr.control.Option;

public abstract class DestinationInstance<I extends DestinationInstance<I, T>, T extends Destination<T, I, ?>> {
    protected final T destination;

    protected DestinationInstance(@NotNull T destination) {
        this.destination = destination;
    }

    @NotNull
    public T getDestination() {
        return this.destination;
    }

    @NotNull
    public String getIdentifier() {
        return this.destination.getIdentifier();
    }

    @NotNull
    public abstract Option<Location> getLocation(@NotNull Entity var1);

    @NotNull
    public abstract Option<Vector> getVelocity(@NotNull Entity var1);

    public abstract boolean checkTeleportSafety();

    @NotNull
    public abstract Option<String> getFinerPermissionSuffix();

    @ApiStatus.AvailableSince(value="5.4")
    @NotNull
    public Message getDisplayMessage() {
        return Message.of(this.toString(), new MessageReplacement[0]);
    }

    @NotNull
    protected abstract String serialise();

    public String toString() {
        return this.destination.getIdentifier() + ":" + this.serialise();
    }
}

