/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.config.handle;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.mvplugins.multiverse.core.config.handle.BaseConfigurationHandle;
import org.mvplugins.multiverse.core.config.handle.PropertyModifyAction;
import org.mvplugins.multiverse.core.config.node.ConfigNodeNotFoundException;
import org.mvplugins.multiverse.core.config.node.ListValueNode;
import org.mvplugins.multiverse.core.config.node.Node;
import org.mvplugins.multiverse.core.config.node.ValueNode;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.external.vavr.control.Try;

public class StringPropertyHandle {
    @NotNull
    private final BaseConfigurationHandle<?> handle;

    public StringPropertyHandle(@NotNull BaseConfigurationHandle<?> handle) {
        this.handle = handle;
    }

    public Collection<String> getAllPropertyNames() {
        return this.handle.getNodes().getNames();
    }

    public Collection<String> getModifiablePropertyNames(PropertyModifyAction action) {
        return switch (action) {
            case PropertyModifyAction.SET, PropertyModifyAction.RESET -> this.handle.getNodes().getNames();
            case PropertyModifyAction.ADD, PropertyModifyAction.REMOVE -> this.handle.getNodes().stream().filter(node -> node instanceof ListValueNode).map(node -> ((ValueNode)node).getName()).filter(Option::isDefined).map(Option::get).toList();
            default -> Collections.emptyList();
        };
    }

    public Try<Class<?>> getPropertyType(@Nullable String name) {
        return this.findNode(name, ValueNode.class).map(ValueNode::getType);
    }

    public Collection<String> getSuggestedPropertyValue(@Nullable String name, @Nullable String input, @NotNull PropertyModifyAction action) {
        return this.getSuggestedPropertyValue(name, input, action, (CommandSender)Bukkit.getConsoleSender());
    }

    @ApiStatus.AvailableSince(value="5.1")
    public Collection<String> getSuggestedPropertyValue(@Nullable String name, @Nullable String input, @NotNull PropertyModifyAction action, @NotNull CommandSender sender) {
        return switch (action) {
            case PropertyModifyAction.SET -> this.findNode(name, ValueNode.class).map(node -> node.suggest(sender, input)).getOrElse(Collections.emptyList());
            case PropertyModifyAction.ADD -> this.findNode(name, ListValueNode.class).map(node -> node.suggestItem(sender, input)).getOrElse(Collections.emptyList());
            case PropertyModifyAction.REMOVE -> this.findNode(name, ListValueNode.class).map(node -> (List)this.handle.get(node)).map(valueList -> valueList.stream().map(String::valueOf).toList()).getOrElse(Collections.emptyList());
            default -> Collections.emptyList();
        };
    }

    public Try<Object> getProperty(@Nullable String name) {
        return this.findNode(name, ValueNode.class).map(this.handle::get);
    }

    public Try<Void> setProperty(@Nullable String name, @Nullable Object value) {
        return this.findNode(name, ValueNode.class).flatMap(node -> this.handle.set(node, value));
    }

    public Try<Void> addProperty(@Nullable String name, @Nullable Object value) {
        return this.findNode(name, ListValueNode.class).flatMap(node -> this.handle.add(node, value));
    }

    public Try<Void> removeProperty(@Nullable String name, @Nullable Object value) {
        return this.findNode(name, ListValueNode.class).flatMap(node -> this.handle.remove(node, value));
    }

    public Try<Void> resetProperty(@Nullable String name) {
        return this.findNode(name, ValueNode.class).flatMap(this.handle::reset);
    }

    public Try<Void> modifyProperty(@Nullable String name, @Nullable Object value, @NotNull PropertyModifyAction action) {
        return switch (action) {
            case PropertyModifyAction.SET -> this.setProperty(name, value);
            case PropertyModifyAction.ADD -> this.addProperty(name, value);
            case PropertyModifyAction.REMOVE -> this.removeProperty(name, value);
            case PropertyModifyAction.RESET -> this.resetProperty(name);
            default -> Try.failure(new IllegalArgumentException("Unknown action: " + String.valueOf((Object)action)));
        };
    }

    public Try<Void> setPropertyString(@Nullable String name, @Nullable String value) {
        return this.setPropertyString((CommandSender)Bukkit.getConsoleSender(), name, value);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public Try<Void> setPropertyString(@NotNull CommandSender sender, @Nullable String name, @Nullable String value) {
        return this.findNode(name, ValueNode.class).flatMap(node -> node.parseFromString(sender, value).flatMap(parsedValue -> this.handle.set(sender, node, parsedValue)));
    }

    public Try<Void> addPropertyString(@Nullable String name, @Nullable String value) {
        return this.addPropertyString((CommandSender)Bukkit.getConsoleSender(), name, value);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public Try<Void> addPropertyString(@NotNull CommandSender sender, @Nullable String name, @Nullable String value) {
        return this.findNode(name, ListValueNode.class).flatMap(node -> node.parseItemFromString(sender, value).flatMap(parsedValue -> this.handle.add(node, parsedValue)));
    }

    public Try<Void> removePropertyString(@Nullable String name, @Nullable String value) {
        return this.removePropertyString((CommandSender)Bukkit.getConsoleSender(), name, value);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public Try<Void> removePropertyString(@NotNull CommandSender sender, @Nullable String name, @Nullable String value) {
        return this.findNode(name, ListValueNode.class).flatMap(node -> node.parseItemFromString(sender, value).flatMap(parsedValue -> this.handle.remove(node, parsedValue)));
    }

    public Try<Void> modifyPropertyString(@Nullable String name, @Nullable String value, @NotNull PropertyModifyAction action) {
        return this.modifyPropertyString((CommandSender)Bukkit.getConsoleSender(), name, value, action);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public Try<Void> modifyPropertyString(@NotNull CommandSender sender, @Nullable String name, @Nullable String value, @NotNull PropertyModifyAction action) {
        if (action.isRequireValue() && value == null) {
            return Try.failure(new IllegalArgumentException("Value is required for PropertyModifyAction: " + String.valueOf((Object)action)));
        }
        return switch (action) {
            case PropertyModifyAction.SET -> this.setPropertyString(sender, name, value);
            case PropertyModifyAction.ADD -> this.addPropertyString(sender, name, value);
            case PropertyModifyAction.REMOVE -> this.removePropertyString(sender, name, value);
            case PropertyModifyAction.RESET -> this.resetProperty(name);
            default -> Try.failure(new IllegalArgumentException("Unknown action: " + String.valueOf((Object)action)));
        };
    }

    private <T extends Node> Try<T> findNode(@Nullable String name, @NotNull Class<T> type) {
        return this.handle.getNodes().findNode(name, type).toTry(() -> new ConfigNodeNotFoundException(name));
    }
}

