/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import java.util.Collections;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.flag.CommandFlag;
import org.mvplugins.multiverse.core.command.flag.CommandFlagsManager;
import org.mvplugins.multiverse.core.command.flag.CommandValueFlag;
import org.mvplugins.multiverse.core.command.flag.FlagBuilder;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.StringFormatter;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.biomeprovider.BiomeProviderFactory;
import org.mvplugins.multiverse.core.world.generators.GeneratorProvider;
import org.mvplugins.multiverse.core.world.options.CreateWorldOptions;
import org.mvplugins.multiverse.core.world.reasons.CreateFailureReason;
import org.mvplugins.multiverse.external.acf.commands.ACFUtil;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
class CreateCommand
extends CoreCommand {
    private final WorldManager worldManager;
    private final Flags flags;

    @Inject
    CreateCommand(@NotNull WorldManager worldManager, @NotNull Flags flags) {
        this.worldManager = worldManager;
        this.flags = flags;
    }

    @Subcommand(value="create")
    @CommandPermission(value="multiverse.core.create")
    @CommandCompletion(value="@empty @environments @flags:groupName=mvcreate")
    @Syntax(value="<name> <environment> [--seed <seed> --generator <generator[:id]> --world-type <worldtype> --adjust-spawn --no-structures --biome <biome> --properties <prop1=value1,prop2=value2,...>]")
    @Description(value="{@@mv-core.create.description}")
    void onCreateCommand(MVCommandIssuer issuer, @Syntax(value="<name>") @Description(value="{@@mv-core.create.name.description}") String worldName, @Syntax(value="<environment>") @Description(value="{@@mv-core.create.environment.description}") World.Environment environment, @Optional @Syntax(value="[--seed <seed> --generator <generator[:id]> --world-type <worldtype> --adjust-spawn --no-structures --biome <biome> --properties <prop1=value1,prop2=value2,...>]") @Description(value="{@@mv-core.create.flags.description}") String[] flagArray) {
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        this.messageWorldDetails(issuer, worldName, environment, parsedFlags);
        issuer.sendInfo(MVCorei18n.CREATE_LOADING);
        this.worldManager.createWorld(CreateWorldOptions.worldName(worldName).biome(parsedFlags.flagValue(this.flags.biome, "")).environment(environment).seed(parsedFlags.flagValue(this.flags.seed)).worldType(parsedFlags.flagValue(this.flags.worldType, WorldType.NORMAL)).useSpawnAdjust(!parsedFlags.hasFlag(this.flags.noAdjustSpawn)).generator(parsedFlags.flagValue(this.flags.generator, "")).generatorSettings(parsedFlags.flagValue(this.flags.generatorSettings, "")).generateStructures(!parsedFlags.hasFlag(this.flags.noStructures)).worldPropertyStrings(StringFormatter.parseCSVMap(parsedFlags.flagValue(this.flags.properties)))).onSuccess(newWorld -> this.messageSuccess(issuer, (LoadedMultiverseWorld)newWorld)).onFailure(failure -> this.messageFailure(issuer, (Attempt.Failure<LoadedMultiverseWorld, CreateFailureReason>)failure));
    }

    private void messageWorldDetails(MVCommandIssuer issuer, String worldName, World.Environment environment, ParsedCommandFlags parsedFlags) {
        issuer.sendInfo((MessageKeyProvider)MVCorei18n.CREATE_PROPERTIES, MessageReplacement.replace("{worldName}").with(worldName));
        issuer.sendInfo((MessageKeyProvider)MVCorei18n.CREATE_PROPERTIES_ENVIRONMENT, MessageReplacement.replace("{environment}").with(environment.name()));
        issuer.sendInfo((MessageKeyProvider)MVCorei18n.CREATE_PROPERTIES_SEED, MessageReplacement.replace("{seed}").with(parsedFlags.flagValue(this.flags.seed, "RANDOM")));
        issuer.sendInfo((MessageKeyProvider)MVCorei18n.CREATE_PROPERTIES_WORLDTYPE, MessageReplacement.replace("{worldType}").with(parsedFlags.flagValue(this.flags.worldType, WorldType.NORMAL).name()));
        issuer.sendInfo((MessageKeyProvider)MVCorei18n.CREATE_PROPERTIES_ADJUSTSPAWN, MessageReplacement.replace("{adjustSpawn}").with(String.valueOf(!parsedFlags.hasFlag(this.flags.noAdjustSpawn))));
        if (parsedFlags.hasFlag(this.flags.biome)) {
            issuer.sendInfo((MessageKeyProvider)MVCorei18n.CREATE_PROPERTIES_BIOME, MessageReplacement.replace("{biome}").with(parsedFlags.flagValue(this.flags.biome)));
        }
        if (parsedFlags.hasFlag(this.flags.generator)) {
            issuer.sendInfo((MessageKeyProvider)MVCorei18n.CREATE_PROPERTIES_GENERATOR, MessageReplacement.replace("{generator}").with(parsedFlags.flagValue(this.flags.generator)));
        }
        if (parsedFlags.hasFlag(this.flags.generatorSettings)) {
            issuer.sendInfo((MessageKeyProvider)MVCorei18n.CREATE_PROPERTIES_GENERATORSETTINGS, MessageReplacement.replace("{generatorSettings}").with(parsedFlags.flagValue(this.flags.generatorSettings)));
        }
        issuer.sendInfo((MessageKeyProvider)MVCorei18n.CREATE_PROPERTIES_STRUCTURES, MessageReplacement.replace("{structures}").with(String.valueOf(!parsedFlags.hasFlag(this.flags.noStructures))));
    }

    private void messageSuccess(MVCommandIssuer issuer, LoadedMultiverseWorld newWorld) {
        CoreLogging.fine("World create success: " + String.valueOf(newWorld), new Object[0]);
        issuer.sendInfo((MessageKeyProvider)MVCorei18n.CREATE_SUCCESS, MessageReplacement.Replace.WORLD.with(newWorld.getName()));
    }

    private void messageFailure(MVCommandIssuer issuer, Attempt.Failure<LoadedMultiverseWorld, CreateFailureReason> failure) {
        CoreLogging.fine("World create failure: " + String.valueOf(failure), new Object[0]);
        issuer.sendError(failure.getFailureMessage());
    }

    @Service
    private static final class Flags
    extends FlagBuilder {
        private static final String NAME = "mvcreate";
        private GeneratorProvider generatorProvider;
        private BiomeProviderFactory biomeProviderFactory;
        private final CommandValueFlag<String> seed = (CommandValueFlag)this.flag(((CommandValueFlag.Builder)((CommandValueFlag.Builder)CommandValueFlag.builder("--seed", String.class).addAlias("-s")).completion(input -> Collections.singleton(String.valueOf(ACFUtil.RANDOM.nextLong())))).build());
        private final CommandValueFlag<String> generator = (CommandValueFlag)this.flag(((CommandValueFlag.Builder)((CommandValueFlag.Builder)CommandValueFlag.builder("--generator", String.class).addAlias("-g")).completion(input -> this.generatorProvider.suggestGeneratorString((String)input))).build());
        private final CommandValueFlag<String> generatorSettings = (CommandValueFlag)this.flag(((CommandValueFlag.Builder)CommandValueFlag.builder("--generator-settings", String.class).addAlias("-gs")).build());
        private final CommandValueFlag<WorldType> worldType = (CommandValueFlag)this.flag(((CommandValueFlag.EnumBuilder)CommandValueFlag.enumBuilder("--world-type", WorldType.class).addAlias("-t")).build());
        private final CommandFlag noAdjustSpawn = this.flag(((CommandFlag.Builder)CommandFlag.builder("--no-adjust-spawn").addAlias("-n")).build());
        private final CommandFlag noStructures = this.flag(((CommandFlag.Builder)CommandFlag.builder("--no-structures").addAlias("-a")).build());
        private final CommandValueFlag<String> biome = (CommandValueFlag)this.flag(((CommandValueFlag.Builder)((CommandValueFlag.Builder)CommandValueFlag.builder("--biome", String.class).addAlias("-b")).completion(input -> this.biomeProviderFactory.suggestBiomeString((String)input))).build());
        private final CommandValueFlag<String> properties = (CommandValueFlag)this.flag(((CommandValueFlag.Builder)CommandValueFlag.builder("--properties", String.class).addAlias("-p")).build());

        @Inject
        private Flags(@NotNull CommandFlagsManager flagsManager, @NotNull GeneratorProvider generatorProvider, @NotNull BiomeProviderFactory biomeProviderFactory) {
            super(NAME, flagsManager);
            this.generatorProvider = generatorProvider;
            this.biomeProviderFactory = biomeProviderFactory;
        }
    }

    @Service
    private static final class LegacyAlias
    extends CreateCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(@NotNull WorldManager worldManager, @NotNull Flags flags) {
            super(worldManager, flags);
        }

        @Override
        @CommandAlias(value="mvcreate|mvc")
        void onCreateCommand(MVCommandIssuer issuer, String worldName, World.Environment environment, String[] flags) {
            super.onCreateCommand(issuer, worldName, environment, flags);
        }
    }
}

