/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.command.flag;

import java.util.HashMap;
import java.util.Map;
import org.mvplugins.multiverse.core.command.flag.CommandFlag;
import org.mvplugins.multiverse.core.command.flag.CommandValueFlag;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;

public class ParsedCommandFlags {
    public static final ParsedCommandFlags EMPTY = new ParsedCommandFlags();
    private final Map<String, Object> flagValues = new HashMap<String, Object>();

    ParsedCommandFlags() {
    }

    void addFlagResult(@NotNull String key, @Nullable Object value) {
        this.flagValues.put(key, value);
    }

    public boolean hasFlag(@NotNull CommandFlag flag) {
        return this.hasFlag(flag.getKey());
    }

    public boolean hasFlag(@Nullable String key) {
        return this.flagValues.containsKey(key);
    }

    public boolean hasFlagValue(@Nullable String key) {
        return this.flagValue(key, Object.class) != null;
    }

    @Nullable
    public <T> T flagValue(@NotNull CommandFlag flag, @NotNull Class<T> type) {
        return this.flagValue(flag.getKey(), type);
    }

    @Nullable
    public <T> T flagValue(@Nullable String key, @NotNull Class<T> type) {
        Object value = this.flagValues.get(key);
        return (T)value;
    }

    @Nullable
    public <T> T flagValue(@NotNull CommandValueFlag<T> flag) {
        return this.flagValue(flag.getKey(), flag.getType());
    }

    @NotNull
    public <T> T flagValue(@NotNull CommandValueFlag<T> flag, @NotNull T defaultValue) {
        return this.flagValue(flag.getKey(), defaultValue, flag.getType());
    }

    @NotNull
    public <T> T flagValue(@Nullable String key, @NotNull T defaultValue, @NotNull Class<T> type) {
        T value = this.flagValue(key, type);
        return value != null ? value : defaultValue;
    }
}

