/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.command.flag;

import java.util.ArrayList;
import java.util.List;
import org.mvplugins.multiverse.core.command.flag.CommandFlag;
import org.mvplugins.multiverse.core.command.flag.CommandFlagGroup;
import org.mvplugins.multiverse.core.command.flag.CommandFlagsManager;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.external.jakarta.annotation.PostConstruct;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Contract;

@Contract
public abstract class FlagBuilder {
    private final String name;
    private final CommandFlagsManager flagsManager;
    private final List<CommandFlag> flags;

    protected FlagBuilder(@NotNull String name, @NotNull CommandFlagsManager flagsManager) {
        this.name = name;
        this.flagsManager = flagsManager;
        this.flags = new ArrayList<CommandFlag>();
    }

    @PostConstruct
    private void postConstruct() {
        CommandFlagGroup.Builder flagGroupBuilder = CommandFlagGroup.builder(this.name);
        this.flags.forEach(flagGroupBuilder::add);
        this.registerFlagGroup(flagGroupBuilder.build());
    }

    private void registerFlagGroup(@NotNull CommandFlagGroup flagGroup) {
        this.flagsManager.registerFlagGroup(flagGroup);
        CoreLogging.finer("Registered flag group: " + flagGroup.getName(), new Object[0]);
    }

    protected <T extends CommandFlag> T flag(T flag) {
        this.flags.add(flag);
        CoreLogging.finer("Added flag: " + String.valueOf(flag), new Object[0]);
        return flag;
    }

    @NotNull
    public ParsedCommandFlags parse(@NotNull String[] flags) {
        return this.flagsManager.parse(this.name, flags);
    }
}

