/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.command.flag;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mvplugins.multiverse.core.command.flag.CommandFlag;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;

public class CommandFlagGroup {
    private final String name;
    private final List<String> keys;
    private final Map<String, CommandFlag> keysFlagMap;

    @NotNull
    public static Builder builder(@NotNull String name) {
        return new Builder(name);
    }

    protected CommandFlagGroup(@NotNull Builder builder) {
        this.name = builder.name;
        this.keys = builder.keys;
        this.keysFlagMap = builder.keysFlagMap;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean hasKey(@Nullable String key) {
        return this.keysFlagMap.containsKey(key);
    }

    @NotNull
    public Set<String> getRemainingKeys(@NotNull String[] flags) {
        HashSet<String> keysRemaining = new HashSet<String>(this.keys);
        for (String flag : flags) {
            CommandFlag mvFlag = this.getFlagByKey(flag);
            if (mvFlag == null) continue;
            keysRemaining.remove(mvFlag.getKey());
        }
        return keysRemaining;
    }

    @Nullable
    public CommandFlag getFlagByKey(String key) {
        return this.keysFlagMap.get(key);
    }

    public static class Builder {
        private final String name;
        private final List<String> keys;
        private final Map<String, CommandFlag> keysFlagMap;

        public Builder(@NotNull String name) {
            this.name = name;
            this.keys = new ArrayList<String>();
            this.keysFlagMap = new HashMap<String, CommandFlag>();
        }

        @NotNull
        public Builder add(CommandFlag flag) {
            this.keys.add(flag.getKey());
            this.keysFlagMap.put(flag.getKey(), flag);
            flag.getAliases().forEach(alias -> this.keysFlagMap.put((String)alias, flag));
            return this;
        }

        @NotNull
        public CommandFlagGroup build() {
            return new CommandFlagGroup(this);
        }
    }
}

