/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.mvplugins.multiverse.core.MultiverseCore;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.economy.MVEconomist;
import org.mvplugins.multiverse.core.utils.MinecraftTimeFormatter;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.core.utils.StringFormatter;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.jakarta.annotation.PostConstruct;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Option;

@Service
final class PlaceholderExpansionHook
extends PlaceholderExpansion {
    private final MultiverseCore plugin;
    private final CoreConfig coreConfig;
    private final WorldManager worldManager;
    private final MVEconomist economist;

    @Inject
    public PlaceholderExpansionHook(@NotNull MultiverseCore plugin, @NotNull CoreConfig coreConfig, @NotNull WorldManager worldManager, @NotNull MVEconomist economist) {
        this.plugin = plugin;
        this.coreConfig = coreConfig;
        this.worldManager = worldManager;
        this.economist = economist;
    }

    @PostConstruct
    public boolean register() {
        return super.register();
    }

    public void warning(String msg) {
        if (this.coreConfig.getWarnInvalidPapiFormat()) {
            super.warning(msg);
        }
    }

    @NotNull
    public String getIdentifier() {
        return "multiverse-core";
    }

    @NotNull
    public String getAuthor() {
        return StringFormatter.joinAnd(this.plugin.getDescription().getAuthors());
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onRequest(OfflinePlayer offlinePlayer, @NotNull String params) {
        ArrayList paramsArray = Lists.newArrayList((Object[])REPatterns.UNDERSCORE.split(params));
        if (paramsArray.isEmpty()) {
            this.warning("No placeholder key defined");
            return null;
        }
        String placeholder = ((String)paramsArray.remove(0)).toLowerCase(Locale.ENGLISH);
        return this.parseWorldName(offlinePlayer, paramsArray).flatMap(worldName -> this.worldManager.getWorld((String)worldName).onEmpty(() -> this.warning("Multiverse World not found: " + worldName))).flatMap(world -> world.asLoadedWorld().flatMap(loadedWorld -> this.getLoadedWorldPlaceHolderValue(placeholder, paramsArray, (LoadedMultiverseWorld)loadedWorld)).orElse(() -> this.getWorldPlaceHolderValue(placeholder, paramsArray, (MultiverseWorld)world))).getOrElse(() -> this.coreConfig.getInvalidPapiFormatReturnsBlank() ? "" : null);
    }

    @NotNull
    private Option<String> parseWorldName(OfflinePlayer offlinePlayer, List<String> paramsArray) {
        if (paramsArray.isEmpty()) {
            if (offlinePlayer instanceof Player) {
                Player player = (Player)offlinePlayer;
                return Option.of(player.getWorld().getName());
            }
            this.warning("You must specify a world name for non-player placeholders");
            return Option.none();
        }
        String paramWorldName = paramsArray.get(paramsArray.size() - 1);
        if (this.worldManager.isWorld(paramWorldName)) {
            paramsArray.remove(paramsArray.size() - 1);
            return Option.of(paramWorldName);
        }
        if (offlinePlayer instanceof Player) {
            Player player = (Player)offlinePlayer;
            return Option.of(player.getWorld().getName());
        }
        this.warning("Multiverse World not found: " + paramWorldName);
        return Option.none();
    }

    @NotNull
    private Option<String> getWorldPlaceHolderValue(@NotNull String placeholder, @NotNull List<String> placeholderParams, @NotNull MultiverseWorld world) {
        return Option.of(switch (placeholder) {
            case "alias" -> world.getAliasOrName();
            case "animalspawn" -> String.valueOf(world.getEntitySpawnConfig().getSpawnCategoryConfig(SpawnCategory.ANIMAL).isSpawn());
            case "autoheal" -> String.valueOf(world.getAutoHeal());
            case "blacklist" -> String.join((CharSequence)", ", world.getWorldBlacklist());
            case "currency" -> String.valueOf(world.getCurrency());
            case "difficulty" -> world.getDifficulty().toString();
            case "entryfee" -> this.economist.formatPrice(world.getPrice(), world.getCurrency());
            case "environment" -> world.getEnvironment().toString().toLowerCase();
            case "flight" -> String.valueOf(world.isAllowFlight());
            case "gamemode" -> world.getGameMode().toString().toLowerCase();
            case "generator" -> world.getGenerator();
            case "hunger" -> String.valueOf(world.isHunger());
            case "monstersspawn" -> String.valueOf(world.getEntitySpawnConfig().getSpawnCategoryConfig(SpawnCategory.MONSTER).isSpawn());
            case "name" -> world.getName();
            case "playerlimit" -> String.valueOf(world.getPlayerLimit());
            case "price" -> String.valueOf(world.getPrice());
            case "pvp" -> String.valueOf(world.getPvp());
            case "seed" -> String.valueOf(world.getSeed());
            case "weather" -> String.valueOf(world.isAllowWeather());
            case "playercount", "time", "type" -> {
                this.warning("Placeholder '" + placeholder + "' is only available for loaded worlds.");
                yield null;
            }
            default -> {
                this.warning("Unknown Placeholder: " + placeholder);
                yield null;
            }
        });
    }

    @NotNull
    private Option<String> getLoadedWorldPlaceHolderValue(@NotNull String placeholder, @NotNull List<String> placeholderParams, @NotNull LoadedMultiverseWorld world) {
        return Option.of(switch (placeholder) {
            case "playercount" -> String.valueOf(world.getBukkitWorld().map(World::getPlayers).map(List::size).getOrElse(-1));
            case "time" -> {
                String timeFormat = !placeholderParams.isEmpty() ? placeholderParams.get(0) : "";
                long time = world.getBukkitWorld().map(World::getTime).getOrElse(0L);
                switch (timeFormat) {
                    case "": {
                        yield String.valueOf(time);
                    }
                    case "12h": {
                        yield MinecraftTimeFormatter.format12h(time);
                    }
                    case "24h": {
                        yield MinecraftTimeFormatter.format24h(time);
                    }
                }
                yield MinecraftTimeFormatter.formatTime(time, timeFormat);
            }
            case "type" -> world.getBukkitWorld().map(World::getWorldType).map(Enum::name).getOrElse("null");
            default -> null;
        });
    }
}

