/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.external.jvnet.hk2.internal;

import org.mvplugins.multiverse.external.glassfish.hk2.api.ActiveDescriptor;
import org.mvplugins.multiverse.external.glassfish.hk2.api.Injectee;
import org.mvplugins.multiverse.external.glassfish.hk2.api.InjectionResolver;
import org.mvplugins.multiverse.external.glassfish.hk2.api.MultiException;
import org.mvplugins.multiverse.external.glassfish.hk2.api.ServiceHandle;
import org.mvplugins.multiverse.external.glassfish.hk2.api.UnsatisfiedDependencyException;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jakarta.inject.Named;
import org.mvplugins.multiverse.external.jvnet.hk2.internal.ServiceLocatorImpl;

@Named(value="SystemInjectResolver")
public class ThreeThirtyResolver
implements InjectionResolver<Inject> {
    private final ServiceLocatorImpl locator;

    ThreeThirtyResolver(ServiceLocatorImpl locator) {
        this.locator = locator;
    }

    @Override
    public Object resolve(Injectee injectee, ServiceHandle<?> root) {
        ActiveDescriptor<?> ad = this.locator.getInjecteeDescriptor(injectee);
        if (ad == null) {
            if (injectee.isOptional()) {
                return null;
            }
            throw new MultiException(new UnsatisfiedDependencyException(injectee, this.locator.getName()));
        }
        return this.locator.getService(ad, root, injectee);
    }

    @Override
    public boolean isConstructorParameterIndicator() {
        return false;
    }

    @Override
    public boolean isMethodParameterIndicator() {
        return false;
    }

    public String toString() {
        return "ThreeThirtyResolver(" + this.locator + "," + System.identityHashCode(this) + ")";
    }
}

