/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.world.options;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.mvplugins.multiverse.external.acf.commands.ACFUtil;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jetbrains.annotations.UnmodifiableView;

public final class CreateWorldOptions {
    private final String worldName;
    private String biome = "";
    private World.Environment environment = World.Environment.NORMAL;
    private boolean generateStructures = true;
    private String generator = null;
    private String generatorSettings = "";
    private long seed;
    private boolean useSpawnAdjust = true;
    private WorldType worldType = WorldType.NORMAL;
    private boolean doFolderCheck = true;
    private final Map<String, String> worldPropertyStrings = new HashMap<String, String>();

    @NotNull
    public static CreateWorldOptions worldName(@NotNull String worldName) {
        return new CreateWorldOptions(worldName);
    }

    CreateWorldOptions(@NotNull String worldName) {
        this.worldName = worldName;
        this.seed = ACFUtil.RANDOM.nextLong();
    }

    @NotNull
    public String worldName() {
        return this.worldName;
    }

    @NotNull
    public CreateWorldOptions biome(@NotNull String biome) {
        this.biome = biome;
        return this;
    }

    @NotNull
    public String biome() {
        return this.biome;
    }

    @NotNull
    public CreateWorldOptions environment(@NotNull World.Environment environmentInput) {
        this.environment = environmentInput;
        return this;
    }

    @NotNull
    public World.Environment environment() {
        return this.environment;
    }

    @NotNull
    public CreateWorldOptions generateStructures(boolean generateStructuresInput) {
        this.generateStructures = generateStructuresInput;
        return this;
    }

    public boolean generateStructures() {
        return this.generateStructures;
    }

    @NotNull
    public CreateWorldOptions generator(@Nullable String generatorInput) {
        this.generator = generatorInput;
        return this;
    }

    @Nullable
    public String generator() {
        return this.generator;
    }

    @NotNull
    public CreateWorldOptions generatorSettings(@NotNull String generatorSettings) {
        this.generatorSettings = generatorSettings;
        return this;
    }

    @NotNull
    public String generatorSettings() {
        return this.generatorSettings;
    }

    @NotNull
    public CreateWorldOptions seed(@Nullable String seedInput) {
        if (seedInput == null) {
            return this;
        }
        try {
            this.seed = Long.parseLong(seedInput);
        }
        catch (NumberFormatException numberformatexception) {
            this.seed = seedInput.hashCode();
        }
        return this;
    }

    @NotNull
    public CreateWorldOptions seed(long seedInput) {
        this.seed = seedInput;
        return this;
    }

    public long seed() {
        return this.seed;
    }

    @NotNull
    public CreateWorldOptions useSpawnAdjust(boolean useSpawnAdjustInput) {
        this.useSpawnAdjust = useSpawnAdjustInput;
        return this;
    }

    public boolean useSpawnAdjust() {
        return this.useSpawnAdjust;
    }

    @NotNull
    public CreateWorldOptions worldType(@NotNull WorldType worldTypeInput) {
        this.worldType = worldTypeInput;
        return this;
    }

    @NotNull
    public WorldType worldType() {
        return this.worldType;
    }

    @NotNull
    public CreateWorldOptions doFolderCheck(boolean doFolderCheckInput) {
        this.doFolderCheck = doFolderCheckInput;
        return this;
    }

    public boolean doFolderCheck() {
        return this.doFolderCheck;
    }

    @ApiStatus.AvailableSince(value="5.5")
    @NotNull
    public CreateWorldOptions worldPropertyString(@NotNull String key, @Nullable String value) {
        this.worldPropertyStrings.put(key, value);
        return this;
    }

    @ApiStatus.AvailableSince(value="5.5")
    @NotNull
    public CreateWorldOptions worldPropertyStrings(@NotNull @NotNull Map<@NotNull String, @Nullable String> worldProperties) {
        this.worldPropertyStrings.putAll(worldProperties);
        return this;
    }

    @ApiStatus.AvailableSince(value="5.5")
    public @UnmodifiableView @NotNull Map<String, String> worldPropertyStrings() {
        return Collections.unmodifiableMap(this.worldPropertyStrings);
    }
}

