/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.world.helpers;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.mvplugins.multiverse.core.MultiverseCore;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.UnmodifiableView;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Option;

@Service
@ApiStatus.AvailableSince(value="5.4")
public final class ConcurrentPlayerWorldTracker
implements Listener {
    private final Map<String, String> playerWorldMap = new ConcurrentHashMap<String, String>();

    @Inject
    ConcurrentPlayerWorldTracker(@NotNull MultiverseCore plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @ApiStatus.AvailableSince(value="5.4")
    @NotNull
    public @UnmodifiableView Collection<String> getOnlinePlayers() {
        return Collections.unmodifiableCollection(this.playerWorldMap.keySet());
    }

    @ApiStatus.AvailableSince(value="5.4")
    @NotNull
    public Option<String> getPlayerWorld(String playerName) {
        return Option.of(this.playerWorldMap.get(playerName));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    private void onPlayerJoin(PlayerJoinEvent event) {
        this.setPlayerWorld(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    private void onPlayerChangedWorld(@NotNull PlayerChangedWorldEvent event) {
        this.setPlayerWorld(event.getPlayer());
    }

    private void setPlayerWorld(Player player) {
        String playerName = player.getName();
        String worldName = player.getWorld().getName();
        this.playerWorldMap.put(playerName, worldName);
    }

    @EventHandler
    private void onPlayerQuit(@NotNull PlayerQuitEvent event) {
        String playerName = event.getPlayer().getName();
        this.playerWorldMap.remove(playerName);
    }
}

