/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.world;

import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldType;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.teleportation.BlockSafety;
import org.mvplugins.multiverse.core.teleportation.LocationManipulation;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldConfig;
import org.mvplugins.multiverse.core.world.entity.EntityPurger;
import org.mvplugins.multiverse.core.world.location.NullSpawnLocation;
import org.mvplugins.multiverse.core.world.location.SpawnLocation;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.vavr.control.Option;

public final class LoadedMultiverseWorld
extends MultiverseWorld {
    private final UUID worldUid;
    private final BlockSafety blockSafety;
    private final LocationManipulation locationManipulation;
    private final EntityPurger entityPurger;

    LoadedMultiverseWorld(@NotNull World world, @NotNull WorldConfig worldConfig, @NotNull CoreConfig config, @NotNull BlockSafety blockSafety, @NotNull LocationManipulation locationManipulation, @NotNull EntityPurger entityPurger) {
        super(world.getName(), worldConfig, config);
        this.worldUid = world.getUID();
        this.blockSafety = blockSafety;
        this.locationManipulation = locationManipulation;
        this.entityPurger = entityPurger;
        this.setupWorldConfig(world);
        this.setupSpawnLocation(world);
        this.purgeEntitiesOnLoad();
    }

    private void setupWorldConfig(World world) {
        this.worldConfig.setMVWorld(this);
        this.worldConfig.load();
        this.worldConfig.setEnvironment(world.getEnvironment());
        this.worldConfig.setSeed(world.getSeed());
    }

    private void setupSpawnLocation(World world) {
        SpawnLocation spawnLocation = this.worldConfig.getSpawnLocation();
        if (spawnLocation == null || spawnLocation instanceof NullSpawnLocation) {
            SpawnLocation newLocation = new SpawnLocation(this.readSpawnFromWorld(world));
            this.worldConfig.setSpawnLocation(newLocation);
        }
    }

    private Location readSpawnFromWorld(World world) {
        Location location = world.getSpawnLocation();
        if (this.blockSafety.canSpawnAtLocationSafely(location)) {
            return location;
        }
        if (!this.getAdjustSpawn()) {
            CoreLogging.fine("Spawn location from world.dat file was unsafe!!", new Object[0]);
            CoreLogging.fine("NOT adjusting spawn for '" + this.getAliasOrName() + "' because you told me not to.", new Object[0]);
            CoreLogging.fine("To turn on spawn adjustment for this world simply type:", new Object[0]);
            CoreLogging.fine("/mvm set adjustspawn true " + this.getAliasOrName(), new Object[0]);
            return location;
        }
        CoreLogging.warning("Spawn location from world.dat file was unsafe. Adjusting...", new Object[0]);
        CoreLogging.warning("Original Location: " + this.locationManipulation.strCoordsRaw(location), new Object[0]);
        Location newSpawn = this.blockSafety.findSafeSpawnLocation(location);
        if (newSpawn != null) {
            CoreLogging.info("New Spawn for '%s' is located at: %s", this.getName(), this.locationManipulation.locationToString(newSpawn));
            return newSpawn;
        }
        CoreLogging.fine("Checking for a safe location using top block...", new Object[0]);
        Location newerSpawn = this.blockSafety.getTopBlock(new Location(world, 0.0, 0.0, 0.0));
        if (newerSpawn != null) {
            CoreLogging.info("New Spawn for '%s' is located at: %s", this.getName(), this.locationManipulation.locationToString(newerSpawn));
            return newerSpawn;
        }
        CoreLogging.severe("Safe spawn NOT found!!!", new Object[0]);
        return location;
    }

    private void purgeEntitiesOnLoad() {
        if (this.config.isAutoPurgeEntities()) {
            this.entityPurger.purgeEntities(this);
        }
    }

    public UUID getUID() {
        return this.worldUid;
    }

    public Option<World> getBukkitWorld() {
        return Option.of(Bukkit.getWorld((UUID)this.worldUid));
    }

    public Option<WorldType> getWorldType() {
        return this.getBukkitWorld().map(World::getWorldType);
    }

    public Option<Boolean> canGenerateStructures() {
        return this.getBukkitWorld().map(World::canGenerateStructures);
    }

    public Option<List<Player>> getPlayers() {
        return this.getBukkitWorld().map(World::getPlayers);
    }

    public Option<WorldBorder> getWorldBorder() {
        return this.getBukkitWorld().map(World::getWorldBorder);
    }

    @Override
    void setWorldConfig(WorldConfig worldConfig) {
        super.setWorldConfig(worldConfig);
        this.setupWorldConfig(this.getBukkitWorld().get());
    }

    @Override
    public String toString() {
        return "LoadedMultiverseWorld{name='" + this.worldName + "', env='" + String.valueOf(this.getEnvironment()) + "', type='" + String.valueOf(this.getWorldType().getOrNull()) + "', gen='" + this.getGenerator() + "'}";
    }
}

