/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils.matcher;

import java.util.regex.Pattern;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.matcher.StringMatcher;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.vavr.control.Try;

@ApiStatus.AvailableSince(value="5.2")
public class RegexStringMatcher
implements StringMatcher {
    @NotNull
    private final String regexString;
    @Nullable
    private final Pattern regexPattern;

    @ApiStatus.AvailableSince(value="5.2")
    public RegexStringMatcher(@NotNull String regexString) {
        this.regexString = regexString;
        this.regexPattern = this.compileRegex(regexString);
    }

    private Pattern compileRegex(String regexString) {
        if (regexString.startsWith("r=")) {
            regexString = regexString.substring(2);
        }
        String finalRegexString = regexString;
        return (Pattern)Try.of(() -> Pattern.compile(finalRegexString)).onFailure(ex -> CoreLogging.warning("Failed to compile regex '%s': %s", finalRegexString, ex.getMessage())).getOrNull();
    }

    @Override
    public boolean matches(@Nullable String value) {
        if (this.regexPattern == null || value == null) {
            return false;
        }
        return this.regexPattern.matcher(value).matches();
    }
}

