/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.module;

import java.lang.annotation.Annotation;
import java.util.Locale;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.mvplugins.multiverse.core.command.MVCommandManager;
import org.mvplugins.multiverse.core.command.MultiverseCommand;
import org.mvplugins.multiverse.core.dynamiclistener.DynamicListener;
import org.mvplugins.multiverse.core.dynamiclistener.DynamicListenerRegistration;
import org.mvplugins.multiverse.core.inject.PluginServiceLocator;
import org.mvplugins.multiverse.core.inject.PluginServiceLocatorFactory;
import org.mvplugins.multiverse.core.module.MultiverseModuleBinder;
import org.mvplugins.multiverse.core.module.MultiverseModulesRegistry;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jakarta.inject.Provider;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Contract;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.external.vavr.control.Try;

@Contract
public abstract class MultiverseModule
extends JavaPlugin {
    protected PluginServiceLocator serviceLocator;
    @Inject
    protected Provider<MVCommandManager> commandManagerProvider;
    @Inject
    protected Provider<DynamicListenerRegistration> dynamicListenerRegistrationProvider;

    public void onEnable() {
        super.onEnable();
        MultiverseModulesRegistry.get().registerMultiverseModule(this);
    }

    public void onDisable() {
        super.onDisable();
        MultiverseModulesRegistry.get().unregisterMultiverseModule(this);
    }

    public abstract double getTargetCoreVersion();

    public PluginServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    protected double getVersionAsNumber() {
        String[] split = REPatterns.DOT.split(this.getDescription().getVersion());
        if (split.length < 2) {
            return -1.0;
        }
        return Double.parseDouble(split[0] + "." + split[1]);
    }

    protected void initializeDependencyInjection(MultiverseModuleBinder<? extends MultiverseModule> pluginBinder) {
        PluginServiceLocator coreServiceLocator = (PluginServiceLocator)Option.of(MultiverseModulesRegistry.get().getCore()).map(MultiverseModule::getServiceLocator).getOrNull();
        this.serviceLocator = (PluginServiceLocator)PluginServiceLocatorFactory.get().registerPlugin(pluginBinder, coreServiceLocator).flatMap(PluginServiceLocator::enable).getOrElseThrow(exception -> {
            CoreLogging.severe("Failed to initialize dependency injection!", new Object[0]);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return new RuntimeException((Throwable)exception);
        });
    }

    protected void shutdownDependencyInjection() {
        Option.of(this.serviceLocator).peek(PluginServiceLocator::disable).peek(ignore -> {
            this.serviceLocator = null;
        });
    }

    @Deprecated(since="5.0", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    protected void registerEvents(Class<? extends Listener> listenerClass) {
        PluginManager pluginManager = this.getServer().getPluginManager();
        Try.run(() -> this.serviceLocator.getAllServices(listenerClass, new Annotation[0]).forEach(listener -> pluginManager.registerEvents(listener, (Plugin)this))).onFailure(e -> {
            throw new RuntimeException("Failed to register listeners. Terminating...", (Throwable)e);
        });
    }

    protected void registerDynamicListeners(Class<? extends DynamicListener> listenerClass) {
        Try.run(() -> this.serviceLocator.getAllServices(listenerClass, new Annotation[0]).forEach(listener -> this.dynamicListenerRegistrationProvider.get().register((DynamicListener)listener, (Plugin)this))).onFailure(e -> {
            throw new RuntimeException("Failed to register listeners. Terminating...", (Throwable)e);
        });
    }

    protected void registerCommands(Class<? extends MultiverseCommand> commandClass) {
        Try.of(() -> this.commandManagerProvider.get()).andThenTry(commandManager -> commandManager.registerAllCommands(this.serviceLocator.getAllServices(commandClass, new Annotation[0]))).onFailure(e -> {
            CoreLogging.severe("Failed to register commands", new Object[0]);
            e.printStackTrace();
        });
    }

    protected void setUpLocales() {
        Try.of(() -> this.commandManagerProvider.get()).mapTry(MVCommandManager::getLocales).andThen(pluginLocales -> {
            pluginLocales.addFileResClassLoader((Plugin)this);
            pluginLocales.addBundleClassLoader(this.getClassLoader());
            pluginLocales.addMessageBundles(this.getName().toLowerCase(Locale.ENGLISH));
        }).onFailure(e -> {
            CoreLogging.severe("Failed to register locales", new Object[0]);
            e.printStackTrace();
        });
    }
}

