/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.destination.core;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.destination.core.PlayerDestination;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.vavr.control.Option;

public final class PlayerDestinationInstance
extends DestinationInstance<PlayerDestinationInstance, PlayerDestination> {
    private final UUID playerUUID;
    private final String playerName;

    PlayerDestinationInstance(@NotNull PlayerDestination destination, @NotNull Player player) {
        super(destination);
        this.playerUUID = player.getUniqueId();
        this.playerName = player.getName();
    }

    @Override
    @NotNull
    public Option<Location> getLocation(@NotNull Entity teleportee) {
        Player player = Bukkit.getPlayer((UUID)this.playerUUID);
        if (player == null || !player.isOnline()) {
            return Option.none();
        }
        return Option.of(player.getLocation());
    }

    @Override
    @NotNull
    public Option<Vector> getVelocity(@NotNull Entity teleportee) {
        return Option.none();
    }

    @Override
    public boolean checkTeleportSafety() {
        return true;
    }

    @Override
    @NotNull
    public Option<String> getFinerPermissionSuffix() {
        return Option.of(this.playerName);
    }

    @Override
    @NotNull
    public Message getDisplayMessage() {
        return Message.of(this.playerName, new MessageReplacement[0]);
    }

    @Override
    @NotNull
    public String serialise() {
        return this.playerName;
    }
}

