/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.config.handle;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.mvplugins.multiverse.core.config.handle.BaseConfigurationHandle;
import org.mvplugins.multiverse.core.config.migration.ConfigMigrator;
import org.mvplugins.multiverse.core.config.node.NodeGroup;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.vavr.control.Try;

public abstract class FileConfigurationHandle<C extends FileConfiguration>
extends BaseConfigurationHandle<C> {
    @NotNull
    protected final Path configPath;
    @NotNull
    protected final File configFile;

    protected FileConfigurationHandle(@NotNull Path configPath, @Nullable Logger logger, @NotNull NodeGroup nodes, @Nullable ConfigMigrator migrator) {
        super(logger, nodes, migrator);
        this.configPath = configPath;
        this.configFile = configPath.toFile();
    }

    @Override
    public Try<Void> load() {
        return this.tryLoadConfigFile().andThenTry(() -> {
            this.migrateConfig();
            this.setUpNodes();
        });
    }

    private Try<Void> tryLoadConfigFile() {
        return Try.run(() -> {
            this.createConfigFile();
            this.loadConfigObject();
        }).fold(this::handleLoadConfigFailure, Try::success);
    }

    @NotNull
    private Try<Void> handleLoadConfigFailure(Throwable throwable) {
        CoreLogging.severe("Failed to load config file: " + this.configFile.getName(), throwable);
        throwable.printStackTrace();
        return Try.run(() -> {
            Path brokenConfigPath = this.configPath.resolveSibling(this.configFile.getName() + ".broken." + System.currentTimeMillis());
            CoreLogging.severe("Moving broken config file to: " + String.valueOf(brokenConfigPath.getFileName()), new Object[0]);
            Files.copy(this.configPath, brokenConfigPath, new CopyOption[0]);
            Files.delete(this.configPath);
        }).andThenTry(() -> {
            CoreLogging.severe("Multiverse-Core will now regenerate a fresh config file with all default options!", new Object[0]);
            this.createConfigFile();
            this.loadConfigObject();
        });
    }

    protected Try<Void> createConfigFile() {
        return Try.run(() -> {
            if (this.configFile.exists()) {
                return;
            }
            if (!this.configFile.createNewFile()) {
                throw new IOException("Failed to create config file: " + this.configFile.getName());
            }
        });
    }

    protected abstract void loadConfigObject() throws IOException, InvalidConfigurationException;

    public static abstract class Builder<C extends FileConfiguration, B extends Builder<C, B>>
    extends BaseConfigurationHandle.Builder<C, B> {
        @NotNull
        protected final Path configPath;

        protected Builder(@NotNull Path configPath, @NotNull NodeGroup nodes) {
            super(nodes);
            this.configPath = configPath;
        }

        @Override
        @NotNull
        public abstract FileConfigurationHandle<C> build();

        @Override
        protected B self() {
            return (B)this;
        }
    }
}

