/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandManager;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.external.acf.commands.CommandHelp;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
class HelpCommand
extends CoreCommand {
    private final MVCommandManager commandManager;

    @Inject
    HelpCommand(@NotNull MVCommandManager commandManager) {
        this.commandManager = commandManager;
    }

    @org.mvplugins.multiverse.external.acf.commands.annotation.HelpCommand
    @Subcommand(value="help")
    @CommandPermission(value="multiverse.core.help")
    @CommandCompletion(value="@commands:mv")
    @Syntax(value="[filter] [page]")
    @Description(value="{@@mv-core.usage.description}")
    void onHelpCommand(CommandHelp help) {
        if (help.getIssuer().isPlayer()) {
            help.setPerPage(4);
        }
        this.commandManager.showUsage(help);
    }

    @Service
    private static final class LegacyAlias
    extends HelpCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(@NotNull MVCommandManager commandManager) {
            super(commandManager);
        }

        @Override
        @CommandAlias(value="mvhelp")
        public void onHelpCommand(CommandHelp help) {
            super.onHelpCommand(help);
        }
    }
}

