/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import org.bukkit.entity.Player;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.teleportation.LocationManipulation;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Flags;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
class CoordinatesCommand
extends CoreCommand {
    private final LocationManipulation locationManipulation;

    @Inject
    CoordinatesCommand(@NotNull LocationManipulation locationManipulation) {
        this.locationManipulation = locationManipulation;
    }

    @Subcommand(value="coordinates")
    @CommandPermission(value="multiverse.core.coord")
    @Description(value="{@@mv-core.coordinates.description}")
    void onCoordinatesCommand(MVCommandIssuer issuer, @Flags(value="resolve=issuerOnly") Player player, @Flags(value="resolve=issuerOnly") MultiverseWorld world) {
        issuer.sendInfo(MVCorei18n.COORDINATES_INFO_TITLE);
        issuer.sendInfo((MessageKeyProvider)MVCorei18n.COORDINATES_INFO_WORLD, MessageReplacement.Replace.WORLD.with(world.getName()));
        issuer.sendInfo((MessageKeyProvider)MVCorei18n.COORDINATES_INFO_ALIAS, MessageReplacement.replace("{alias}").with(world.getAliasOrName()));
        issuer.sendInfo((MessageKeyProvider)MVCorei18n.COORDINATES_INFO_WORLDSCALE, MessageReplacement.replace("{scale}").with(String.valueOf(world.getScale())));
        issuer.sendInfo((MessageKeyProvider)MVCorei18n.COORDINATES_INFO_COORDINATES, MessageReplacement.replace("{coordinates}").with(this.locationManipulation.strCoords(player.getLocation())));
        issuer.sendInfo((MessageKeyProvider)MVCorei18n.COORDINATES_INFO_DIRECTION, MessageReplacement.replace("{direction}").with(this.locationManipulation.getDirection(player.getLocation())));
    }

    @Service
    private static final class LegacyAlias
    extends CoordinatesCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(@NotNull LocationManipulation locationManipulation) {
            super(locationManipulation);
        }

        @Override
        @CommandAlias(value="mvcoord|mvco")
        @Subcommand(value="coords|coord|co")
        void onCoordinatesCommand(MVCommandIssuer issuer, Player player, MultiverseWorld world) {
            super.onCoordinatesCommand(issuer, player, world);
        }
    }
}

