/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.config.handle.StringPropertyHandle;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
class ConfigCommand
extends CoreCommand {
    private final CoreConfig config;

    @Inject
    ConfigCommand(@NotNull CoreConfig config) {
        this.config = config;
    }

    @Subcommand(value="config")
    @CommandPermission(value="multiverse.core.config")
    @CommandCompletion(value="@mvconfigs @mvconfigvalues")
    @Syntax(value="<name> [value]")
    @Description(value="{@@mv-core.config.description}")
    void onConfigCommand(MVCommandIssuer issuer, @Syntax(value="<name>") @Description(value="{@@mv-core.config.name.description}") String name, @Optional @Syntax(value="[value]") @Description(value="{@@mv-core.config.value.description}") String value) {
        if (value == null) {
            this.showConfigValue(issuer, name);
            return;
        }
        this.updateConfigValue(issuer, name, value);
    }

    private void showConfigValue(MVCommandIssuer issuer, String name) {
        this.config.getStringPropertyHandle().getProperty(name).onSuccess(value -> issuer.sendMessage(MVCorei18n.CONFIG_SHOW_SUCCESS, MessageReplacement.Replace.NAME.with(name), MessageReplacement.Replace.VALUE.with(value))).onFailure(e -> issuer.sendMessage(MVCorei18n.CONFIG_SHOW_ERROR, MessageReplacement.Replace.NAME.with(name), MessageReplacement.Replace.ERROR.with(e)));
    }

    private void updateConfigValue(MVCommandIssuer issuer, String name, String value) {
        StringPropertyHandle stringPropertyHandle = this.config.getStringPropertyHandle();
        stringPropertyHandle.setPropertyString(issuer.getIssuer(), name, value).andThenTry(this.config::save).onSuccess(ignore -> issuer.sendMessage(MVCorei18n.CONFIG_SET_SUCCESS, MessageReplacement.Replace.NAME.with(name), MessageReplacement.Replace.VALUE.with(stringPropertyHandle.getProperty(name).getOrNull()))).onFailure(e -> issuer.sendMessage(MVCorei18n.CONFIG_SET_ERROR, MessageReplacement.Replace.NAME.with(name), MessageReplacement.Replace.VALUE.with(value), MessageReplacement.Replace.ERROR.with(e)));
    }

    @Service
    private static final class LegacyAlias
    extends ConfigCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(@NotNull CoreConfig config) {
            super(config);
        }

        @Override
        @CommandAlias(value="mvconfig|mvconf")
        void onConfigCommand(MVCommandIssuer issuer, String name, String value) {
            super.onConfigCommand(issuer, name, value);
        }
    }
}

