/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.permissions.CorePermissionsChecker;
import org.mvplugins.multiverse.core.teleportation.LocationManipulation;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
class CheckCommand
extends CoreCommand {
    private final CorePermissionsChecker corePermissionsChecker;
    private final LocationManipulation locationManipulation;

    @Inject
    CheckCommand(@NotNull CorePermissionsChecker corePermissionsChecker, @NotNull LocationManipulation locationManipulation) {
        this.corePermissionsChecker = corePermissionsChecker;
        this.locationManipulation = locationManipulation;
    }

    @Subcommand(value="check")
    @CommandPermission(value="multiverse.core.check")
    @CommandCompletion(value="@players @destinations")
    @Syntax(value="<player> <destination>")
    @Description(value="{@@mv-core.check.description}")
    void onCheckCommand(MVCommandIssuer issuer, @Syntax(value="<player>") @Description(value="{@@mv-core.check.player.description}") Player player, @Syntax(value="<destination>") @Description(value="{@@mv-core.check.destination.description}") DestinationInstance<?, ?> destination) {
        issuer.sendInfo((MessageKeyProvider)(this.corePermissionsChecker.checkTeleportPermission((CommandSender)player, (Entity)player, destination) ? MVCorei18n.CHECK_HASPERMISSION : MVCorei18n.CHECK_NOPERMISSION), MessageReplacement.Replace.PLAYER.with(player.getName()), MessageReplacement.Replace.DESTINATION.with(destination));
        MessageReplacement[] messageReplacementArray = new MessageReplacement[1];
        messageReplacementArray[0] = MessageReplacement.replace("{location}").with(destination.getLocation((Entity)player).map(this.locationManipulation::locationToString).map(x$0 -> Message.of(x$0, new MessageReplacement[0])).getOrElse(() -> Message.of((MessageKeyProvider)MVCorei18n.GENERIC_NULL, "Null!", new MessageReplacement[0])));
        issuer.sendInfo((MessageKeyProvider)MVCorei18n.CHECK_LOCATION, messageReplacementArray);
    }

    @Service
    private static final class LegacyAlias
    extends CheckCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(@NotNull CorePermissionsChecker corePermissionsChecker, @NotNull LocationManipulation locationManipulation) {
            super(corePermissionsChecker, locationManipulation);
        }

        @Override
        @CommandAlias(value="mvcheck")
        void onCheckCommand(MVCommandIssuer issuer, Player player, DestinationInstance<?, ?> destination) {
            super.onCheckCommand(issuer, player, destination);
        }
    }
}

